/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.score;

import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.strings.StringConverter;
import com.ssomar.score.utils.strings.StringJoiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommandsClassAbstract<T extends SPlugin>
implements CommandExecutor,
TabExecutor {
    private T sPlugin;
    private final SendMessage sm = new SendMessage();
    private static List<String> argumentsQuantity = new ArrayList<String>();
    private static List<String> argumentsUsage = new ArrayList<String>();
    private List<String> commands = new ArrayList<String>();

    public CommandsClassAbstract(T sPlugin) {
        this.sPlugin = sPlugin;
        argumentsQuantity.add("1");
        argumentsQuantity.add("3");
        argumentsQuantity.add("5");
        argumentsQuantity.add("10");
        argumentsQuantity.add("25");
        argumentsUsage.add("5");
        argumentsUsage.add("10");
        argumentsUsage.add("20");
        argumentsUsage.add("50");
        argumentsUsage.add("100");
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] fullArgs) {
        if (fullArgs.length > 0) {
            String commandName = fullArgs[0].toLowerCase();
            if (this.commands.contains(commandName)) {
                String[] args;
                StringBuilder typedCommand = new StringBuilder(command.getName() + " ");
                if (fullArgs.length > 1) {
                    args = new String[fullArgs.length - 1];
                    for (int i = 0; i < fullArgs.length; ++i) {
                        typedCommand.append(fullArgs[i]).append(" ");
                        if (i == 0) continue;
                        args[i - 1] = fullArgs[i];
                    }
                } else {
                    args = new String[]{};
                }
                Player player = null;
                if (sender instanceof Player && !(player = (Player)sender).hasPermission(this.sPlugin.getShortName().toLowerCase() + ".cmd." + commandName) && !player.hasPermission(this.sPlugin.getShortName().toLowerCase() + ".cmds") && !player.hasPermission(this.sPlugin.getShortName().toLowerCase() + ".*")) {
                    player.sendMessage(StringConverter.coloredString("&4" + this.sPlugin.getNameWithBrackets() + " &cYou don't have the permission to execute this command: &6" + this.sPlugin.getShortName().toLowerCase() + ".cmd." + commandName));
                    return true;
                }
                this.runCommand(sender, sender instanceof Player ? (Player)sender : null, commandName, args, typedCommand.toString());
            } else {
                sender.sendMessage(StringConverter.coloredString("&c" + this.sPlugin.getNameWithBrackets() + " &cInvalid argument! Usage: /" + this.sPlugin.getShortName().toLowerCase() + " &8[ &7" + StringJoiner.join(this.getPermittedCommands(sender), " &c| &7") + " &8]"));
            }
        } else {
            sender.sendMessage(StringConverter.coloredString("&c" + this.sPlugin.getNameWithBrackets() + " &cInvalid argument! Usage: /" + this.sPlugin.getShortName().toLowerCase() + " &8[ &7" + StringJoiner.join(this.getPermittedCommands(sender), " &c| &7") + " &8]"));
        }
        return true;
    }

    public List<String> getPermittedCommands(CommandSender sender) {
        ArrayList<String> permittedCommands = new ArrayList<String>();
        for (String cmd : this.commands) {
            if (!sender.hasPermission(this.sPlugin.getShortName().toLowerCase() + ".cmd." + cmd) && !sender.hasPermission(this.sPlugin.getShortName().toLowerCase() + ".cmds") && !sender.hasPermission(this.sPlugin.getShortName().toLowerCase() + ".*")) continue;
            permittedCommands.add(cmd);
        }
        return permittedCommands;
    }

    public abstract void runCommand(CommandSender var1, @Nullable Player var2, String var3, String[] var4, String var5);

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (command.getName().equalsIgnoreCase(this.sPlugin.getShortName().toLowerCase())) {
            List<Object> arguments = new ArrayList();
            if (args.length == 1) {
                arguments = this.getPermittedCommands(sender);
                Collections.sort(arguments);
                return arguments.stream().filter(element -> element.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
            }
            arguments = this.getOnTabCompleteArguments(sender, command, label, args);
            if (arguments.size() > 0) {
                return arguments;
            }
        }
        return null;
    }

    public abstract List<String> getOnTabCompleteArguments(CommandSender var1, Command var2, String var3, String[] var4);

    public void addCommand(String command) {
        this.commands.add(command);
    }

    public void addCommands(List<String> commands) {
        this.commands.addAll(commands);
    }

    @Generated
    public T getSPlugin() {
        return this.sPlugin;
    }

    @Generated
    public SendMessage getSm() {
        return this.sm;
    }

    @Generated
    public static List<String> getArgumentsQuantity() {
        return argumentsQuantity;
    }

    @Generated
    public static List<String> getArgumentsUsage() {
        return argumentsUsage;
    }
}

