/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.data;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.player.commands.absorption.AbsorptionObject;
import com.ssomar.score.utils.logging.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.ChatColor;

public class AbsorptionQuery {
    private static final String TABLE_ID = "temp_absorptions";
    private static final String COL_ABSORPTION_UUID = "absorption_uuid";
    private static final String COL_PLAYER_UUID = "player_uuid";
    private static final String COL_ABSORPTION_AMOUNT = "absorption";
    private static final String COL_EXPIRY_TIME = "expiry_time";
    private static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS temp_absorptions (absorption_uuid VARCHAR(36) NOT NULL, player_uuid VARCHAR(36) NOT NULL, absorption DOUBLE NOT NULL, expiry_time BIGINT NOT NULL, PRIMARY KEY (absorption_uuid));";

    public static void createNewTable(Connection conn) {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            Utils.sendConsoleMsg("&eSCore &7Creating table &6AbsorptionQuery &7if not exists...");
            statement.execute(CREATE_TABLE);
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("ERROR WHILE CREATING TABLE temp_absorptions IN DATABASE: " + e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertToRecords(Connection conn, UUID absorptionUUID, UUID playerUUID, double absorption_amount, long expiry_time) {
        SsomarDev.testMsg(ChatColor.GOLD + "[#s0017] AbsorptionQuery.insertToRecords() is triggered", true);
        String insertQuery = "INSERT INTO temp_absorptions (absorption_uuid,player_uuid,absorption,expiry_time) VALUES (?, ?, ?, ?);";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("INSERT INTO temp_absorptions (absorption_uuid,player_uuid,absorption,expiry_time) VALUES (?, ?, ?, ?);");
            stmt.setString(1, absorptionUUID.toString());
            stmt.setString(2, playerUUID.toString());
            stmt.setDouble(3, absorption_amount);
            stmt.setLong(4, expiry_time);
            stmt.execute();
        }
        catch (Exception e) {
            SCore.plugin.getLogger().warning("There was complication with the insert query for AbsorptionQuery.java");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<AbsorptionObject> getAbsorptionsToRemove(Connection conn, String playerUUID) {
        SsomarDev.testMsg(ChatColor.GOLD + "[#s0018] &a &6 AbsorptionQuery.getAbsorptionsToRemove() is triggered", true);
        ArrayList<AbsorptionObject> returnArray = new ArrayList<AbsorptionObject>();
        long currentTimeOfExecution = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet rset = null;
        String selectQuery = "SELECT * FROM temp_absorptions WHERE player_uuid=? AND expiry_time < ?;";
        try {
            stmt = conn.prepareStatement("SELECT * FROM temp_absorptions WHERE player_uuid=? AND expiry_time < ?;");
            stmt.setString(1, playerUUID);
            stmt.setLong(2, currentTimeOfExecution);
            rset = stmt.executeQuery();
            while (rset.next()) {
                returnArray.add(new AbsorptionObject(UUID.fromString(rset.getString(1)), UUID.fromString(rset.getString(2)), rset.getDouble(3), rset.getLong(4)));
            }
        }
        catch (Exception e) {
            ArrayList<AbsorptionObject> arrayList = returnArray;
            return arrayList;
        }
        finally {
            if (rset != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return returnArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteAbsorptions(Connection conn, String playerUUID) {
        SsomarDev.testMsg(ChatColor.GOLD + "[#s0018] &a &6 AbsorptionQuery.deleteAbsorptions() is triggered", true);
        long currentTimeOfExecution = System.currentTimeMillis();
        PreparedStatement stmt = null;
        String deleteQuery = "DELETE FROM temp_absorptions WHERE player_uuid=? AND expiry_time < ?;";
        stmt = conn.prepareStatement("DELETE FROM temp_absorptions WHERE player_uuid=? AND expiry_time < ?;");
        stmt.setString(1, playerUUID);
        stmt.setLong(2, currentTimeOfExecution);
        stmt.executeUpdate();
        if (stmt == null) return;
        try {
            stmt.close();
            return;
        }
        catch (Exception exception) {}
        return;
        catch (Exception e) {
            if (stmt == null) return;
            try {
                stmt.close();
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
            catch (Throwable throwable) {
                if (stmt == null) throw throwable;
                try {
                    stmt.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAbsorption(Connection conn, String absorptionUUID) {
        String deleteQuery = "DELETE FROM temp_absorptions WHERE absorption_uuid=?;";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("DELETE FROM temp_absorptions WHERE absorption_uuid=?;");
            stmt.setString(1, absorptionUUID);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            SCore.plugin.getLogger().warning("Failed to delete absorption with UUID: " + absorptionUUID);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

