/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.data;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.ActionInfoSerializer;
import com.ssomar.score.commands.runnable.block.BlockRunCommand;
import com.ssomar.score.data.Database;
import com.ssomar.score.utils.logging.Utils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class BlockCommandsQuery {
    private static final String TABLE_COMMANDS_BLOCK = "commands_block";
    private static final String TABLE_COMMANDS_BLOCK_NAME = "Commands Block";
    private static final String COL_UUID_LAUNCHER = "uuid_launcher";
    private static final String COL_BLOCK_X = "block_x";
    private static final String COL_BLOCK_Y = "block_y";
    private static final String COL_BLOCK_Z = "block_z";
    private static final String COL_BLOCK_WORLD = "block_world";
    private static final String COL_BRUT_COMMAND = "brut_command";
    private static final String COL_RUN_TIME = "run_time";
    private static final String COL_ACTION_INFO = "action_info";
    public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS commands_block (uuid_launcher TEXT NOT NULL, block_x INTEGER NOT NULL, block_y INTEGER NOT NULL, block_z INTEGER NOT NULL, block_world TEXT NOT NULL, brut_command TEXT NOT NULL,run_time LONG NOT NULL, action_info TEXT NOT NULL);";

    public static void createNewTable(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("BlockCommandsQuery createNewTable");
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            Utils.sendConsoleMsg("&eSCore &7Creating table &6Commands Block &7if not exists...");
            stmt.execute(CREATE_TABLE);
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("Error while creating table Commands Block in database " + e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertCommand(Connection conn, List<BlockRunCommand> commands) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("BlockCommandsQuery insertCommand");
        }
        String sql = "INSERT INTO commands_block (uuid_launcher,block_x,block_y,block_z,block_world,brut_command,run_time,action_info) VALUES(?,?,?,?,?,?,?,?)";
        PreparedStatement pstmt = null;
        boolean i = false;
        try {
            pstmt = conn.prepareStatement(sql);
            for (BlockRunCommand command : commands) {
                pstmt.setString(1, command.getLauncherUUID().toString());
                pstmt.setInt(2, command.getBlockX());
                pstmt.setInt(3, command.getBlockY());
                pstmt.setInt(4, command.getBlockZ());
                pstmt.setString(5, command.getBlockWorld().toString());
                pstmt.setString(6, command.getBrutCommand());
                pstmt.setLong(7, command.getRunTime());
                pstmt.setString(8, ActionInfoSerializer.toString(command.getaInfo()));
                pstmt.addBatch();
                pstmt.executeBatch();
            }
        }
        catch (IOException | SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCommands(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("BlockCommandsQuery deleteCommands");
        }
        String sql = "DELETE FROM commands_block";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BlockRunCommand> selectAllCommands(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("BlockCommandsQuery selectAllCommands");
        }
        String sql = "SELECT brut_command,run_time,action_info FROM commands_block ORDER BY run_time";
        ArrayList<BlockRunCommand> list = new ArrayList<BlockRunCommand>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String brutCommand = rs.getString(COL_BRUT_COMMAND);
                long runTime = rs.getLong(COL_RUN_TIME);
                ActionInfo aInfo = null;
                try {
                    aInfo = (ActionInfo)ActionInfoSerializer.fromString(rs.getString(COL_ACTION_INFO));
                }
                catch (Exception e) {
                    SCore.plugin.getLogger().severe("(NOT VERY SERIOUS) The delayed command " + brutCommand + " has been deleted because it was saved in an outdated version.");
                    continue;
                }
                BlockRunCommand pCommand = new BlockRunCommand(brutCommand, runTime, aInfo);
                list.add(pCommand);
            }
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }
}

