/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.data;

import com.ssomar.score.SCore;
import com.ssomar.score.data.Database;
import com.ssomar.score.utils.logging.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class CommandsQuery {
    private static final String TABLE_COMMANDS = "commands";
    private static final String TABLE_COMMANDS_NAME = "Commands";
    private static final String COL_PLAYER = "player";
    private static final String COL_COMMAND = "command";
    public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS commands (player TEXT , command TEXT NOT NULL);";

    public static void createNewTable(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("CommandsQuery createNewTable");
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            Utils.sendConsoleMsg("&eSCore &7Creating table &6Commands &7if not exists...");
            stmt.execute(CREATE_TABLE);
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("Error while creating table Commands in database " + e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertCommand(Connection conn, Player p, String command) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("CommandsQuery insertCommand");
        }
        String sql = "INSERT INTO commands (player,command) VALUES(?,?)";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, p.getName());
            pstmt.setString(2, command);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCommandsForPlayer(Connection conn, Player player) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("CommandsQuery deleteCommandsForPlayer");
        }
        String sql = "DELETE FROM commands where player=?";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, player.getName());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> selectCommandsForPlayer(Connection conn, Player player) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("CommandsQuery selectCommandsForPlayer");
        }
        String sql = "SELECT command FROM commands where player=?";
        ArrayList<String> list = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, player.getName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(rs.getString(COL_COMMAND));
            }
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }
}

