/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.data;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.ActionInfoSerializer;
import com.ssomar.score.commands.runnable.player.PlayerRunCommand;
import com.ssomar.score.data.Database;
import com.ssomar.score.utils.logging.Utils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class PlayerCommandsQuery {
    private static final String TABLE_COMMANDS_PLAYER = "commands_player";
    private static final String TABLE_COMMANDS_PLAYER_NAME = "Commands Player";
    private static final String COL_UUID_LAUNCHER = "uuid_launcher";
    private static final String COL_UUID_RECEIVER = "uuid_receiver";
    private static final String COL_BRUT_COMMAND = "brut_command";
    private static final String COL_RUN_TIME = "run_time";
    private static final String COL_ACTION_INFO = "action_info";
    public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS commands_player (uuid_launcher TEXT NOT NULL, uuid_receiver TEXT NOT NULL, brut_command TEXT NOT NULL,run_time LONG NOT NULL, action_info TEXT NOT NULL);";

    public static void createNewTable(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("PlayerCommandsQuery createNewTable");
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            Utils.sendConsoleMsg("&eSCore &7Creating table &6Commands Player &7if not exists...");
            stmt.execute(CREATE_TABLE);
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("Error while creating table Commands Player in database " + e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void insertCommand(final Connection conn, final List<PlayerRunCommand> commands, boolean async) {
        if (async) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PlayerCommandsQuery.insertCommand(conn, commands);
                }
            };
            SCore.schedulerHook.runAsyncTask(runnable, 0L);
        } else {
            PlayerCommandsQuery.insertCommand(conn, commands);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertCommand(Connection conn, List<PlayerRunCommand> commands) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("PlayerCommandsQuery insertCommand");
        }
        String sql = "INSERT INTO commands_player (uuid_launcher,uuid_receiver,brut_command,run_time,action_info) VALUES(?,?,?,?,?)";
        PreparedStatement pstmt = null;
        int i = 0;
        try {
            pstmt = conn.prepareStatement(sql);
            for (PlayerRunCommand command : commands) {
                pstmt.setString(1, command.getLauncherUUID().toString());
                pstmt.setString(2, command.getReceiverUUID().toString());
                pstmt.setString(3, command.getBrutCommand());
                pstmt.setLong(4, command.getRunTime());
                try {
                    pstmt.setString(5, ActionInfoSerializer.toString(command.getaInfo()));
                }
                catch (IOException err) {
                    SCore.plugin.getLogger().severe("&e[SCore] Couldn't save the delayed command: " + command.getBrutCommand() + " >>" + err.getMessage());
                    continue;
                }
                pstmt.addBatch();
                if (++i % 1000 != 0 && i != commands.size()) continue;
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            Utils.sendConsoleMsg("&e[SCore] " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCommandsForPlayer(Connection conn, UUID uuid) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("PlayerCommandsQuery deleteCommandsForPlayer");
        }
        String sql = "DELETE FROM commands_player where uuid_receiver=?";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, uuid.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCommands(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("PlayerCommandsQuery deleteCommands");
        }
        String sql = "DELETE FROM commands_player";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<UUID, List<PlayerRunCommand>> loadSavedCommands(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("PlayerCommandsQuery loadSavedCommands");
        }
        String sql = "SELECT brut_command,run_time,action_info,uuid_receiver FROM commands_player ORDER BY run_time";
        HashMap<UUID, List<PlayerRunCommand>> map = new HashMap<UUID, List<PlayerRunCommand>>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (!SCore.is1v11Less() && !conn.isValid(5)) {
                SCore.plugin.getLogger().severe("Connection to database is impossible, and can't load the saved commands ");
                HashMap<UUID, List<PlayerRunCommand>> hashMap = map;
                return hashMap;
            }
            pstmt = conn.prepareStatement(sql);
            pstmt.setQueryTimeout(5);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String brutCommand = rs.getString(COL_BRUT_COMMAND);
                long runTime = rs.getLong(COL_RUN_TIME);
                UUID uuidReceiver = UUID.fromString(rs.getString(COL_UUID_RECEIVER));
                OfflinePlayer receiver = Bukkit.getOfflinePlayer((UUID)uuidReceiver);
                ActionInfo aInfo = null;
                try {
                    aInfo = (ActionInfo)ActionInfoSerializer.fromString(rs.getString(COL_ACTION_INFO));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SCore.plugin.getLogger().severe("(NOT VERY SERIOUS) The delayed command " + brutCommand + " for " + receiver.getName() + " has been deleted because it was saved in an outdated version.");
                    continue;
                }
                PlayerRunCommand pCommand = new PlayerRunCommand(brutCommand, runTime, aInfo);
                if (map.containsKey(uuidReceiver)) {
                    ((List)map.get(uuidReceiver)).add(pCommand);
                    continue;
                }
                map.put(uuidReceiver, new ArrayList<PlayerRunCommand>(Collections.singletonList(pCommand)));
            }
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return map;
    }
}

