/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.data;

import com.ssomar.score.SCore;
import com.ssomar.score.data.Database;
import com.ssomar.score.utils.emums.VariableType;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.variables.Variable;
import com.ssomar.score.variables.VariableForEnum;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class VariablesQuery {
    private static final String TABLE_VARIABLES = "variables";
    private static final String TABLE_VARIABLES_NAME = "Variables";
    private static final String COL_INDEX = "col_index";
    private static final String COL_ID = "col_id";
    private static final String COL_TYPE = "col_type";
    private static final String COL_FOR = "col_for";
    private static final String COL_VALUES = "col_values";
    private static final String COL_DEFAULTVALUE = "col_defaultvalue";
    public static final String CREATE_TABLE_SQL = "CREATE TABLE IF NOT EXISTS variables (col_index INT PRIMARY KEY NOT NULL AUTO_INCREMENT, col_id TEXT NOT NULL, col_type TEXT NOT NULL, col_for TEXT NOT NULL, col_values LONGTEXT NOT NULL, col_defaultvalue TEXT NOT NULL)";
    public static final String CREATE_TABLE_SQLITE = "CREATE TABLE IF NOT EXISTS variables (col_index INTEGER PRIMARY KEY, col_id TEXT NOT NULL, col_type TEXT NOT NULL, col_for TEXT NOT NULL, col_values LONGTEXT NOT NULL, col_defaultvalue TEXT NOT NULL)";
    public static final String UPDATE_TABLE = "ALTER TABLE variables MODIFY col_values LONGTEXT NOT NULL";

    public static void createNewTable(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("VariablesQuery createNewTable");
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            Utils.sendConsoleMsg("&eSCore &7Creating table &6Variables &7if not exists...");
            if (Database.useMySQL) {
                stmt.execute(CREATE_TABLE_SQL);
                stmt.execute(UPDATE_TABLE);
            } else {
                stmt.execute(CREATE_TABLE_SQLITE);
            }
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("Error while creating table Variables in database " + e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertVariableNotExists(Connection conn, List<Variable> variables) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("VariablesQuery insertVariableNotExists");
        }
        String sql = "INSERT INTO variables (col_id,col_type,col_for,col_values,col_defaultvalue) SELECT ?,?,?,?,? WHERE NOT EXISTS (SELECT 1 FROM variables WHERE col_id = ?)";
        PreparedStatement pstmt = null;
        int i = 0;
        try {
            pstmt = conn.prepareStatement(sql);
            for (Variable var2 : variables) {
                pstmt.setString(1, var2.getId());
                pstmt.setString(2, ((Optional)var2.getType().getValue()).orElse(VariableType.STRING).toString());
                pstmt.setString(3, ((Optional)var2.getForFeature().getValue()).orElse(VariableForEnum.PLAYER).toString());
                String data = VariablesQuery.transformValues(var2.getValues());
                pstmt.setString(4, data);
                pstmt.setString(5, ((Optional)var2.getDefaultValue().getValue()).orElse("NULL"));
                pstmt.setString(6, var2.getId());
                pstmt.addBatch();
                if (i % 10 == 0 || i == variables.size() - 1) {
                    pstmt.executeBatch();
                }
                ++i;
            }
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("Error while inserting variables in database " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertVariablesAndDeleteIfExists(Connection conn, List<Variable> variables) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("VariablesQuery insertVariablesAndDeleteIfExists");
        }
        for (Variable variable : variables) {
            VariablesQuery.deleteVariable(conn, variable.getId());
        }
        String sql = "INSERT INTO variables (col_id,col_type,col_for,col_values,col_defaultvalue) VALUES(?,?,?,?,?)";
        PreparedStatement pstmt = null;
        boolean i = false;
        try {
            pstmt = conn.prepareStatement(sql);
            for (Variable command : variables) {
                pstmt.setString(1, command.getId());
                pstmt.setString(2, ((Optional)command.getType().getValue()).orElse(VariableType.STRING).toString());
                pstmt.setString(3, ((Optional)command.getForFeature().getValue()).orElse(VariableForEnum.PLAYER).toString());
                String data = VariablesQuery.transformValues(command.getValues());
                pstmt.setString(4, data);
                pstmt.setString(5, ((Optional)command.getDefaultValue().getValue()).orElse("NULL"));
                pstmt.addBatch();
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("Error while inserting variables in database " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void updateVariable(Connection conn, List<Variable> variables) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("VariablesQuery updateVariable");
        }
    }

    public static String transformValues(Map<String, List<String>> entries) {
        StringBuilder data = new StringBuilder();
        for (String key : entries.keySet()) {
            StringBuilder values = new StringBuilder("::::");
            for (String value : entries.get(key)) {
                values.append(value).append("::::");
            }
            values.delete(values.length() - 4, values.length());
            data.append(">>>>").append(key).append((CharSequence)values);
        }
        return data.toString();
    }

    public static HashMap<String, List<String>> deconvertValues(String data) {
        String[] datas;
        HashMap<String, List<String>> entries = new HashMap<String, List<String>>();
        for (String d : datas = data.split(">>>>")) {
            String[] values = d.split("::::");
            String key = values[0];
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(values).subList(1, values.length));
            entries.put(key, list);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteVariables(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("VariablesQuery deleteVariables");
        }
        String sql = "DELETE FROM variables";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("Error while deleting variables in database " + e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteVariable(Connection conn, String id) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("VariablesQuery deleteVariable");
        }
        String sql = "DELETE FROM variables WHERE col_id = '" + id + "'";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("Error while deleting variable in database " + e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Variable> selectAllVariables(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("VariablesQuery selectAllVariables");
        }
        String sql = "SELECT col_id,col_type,col_for,col_values,col_defaultvalue FROM variables";
        ArrayList<Variable> list = new ArrayList<Variable>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String id = rs.getString(COL_ID);
                String type = rs.getString(COL_TYPE);
                String forFeature = rs.getString(COL_FOR);
                String values = rs.getString(COL_VALUES);
                String defaultValue = rs.getString(COL_DEFAULTVALUE);
                Variable v = new Variable(id, "plugins/SCore/variables/" + id + ".yml");
                VariableType variableType = VariableType.valueOf(type);
                v.getType().setValue(Optional.of(variableType));
                VariableForEnum variableForEnum = VariableForEnum.valueOf(forFeature);
                v.getForFeature().setValue(Optional.of(variableForEnum));
                HashMap<String, List<String>> entries = VariablesQuery.deconvertValues(values);
                v.setValues(entries);
                Optional<String> optional = Optional.ofNullable(defaultValue);
                if (optional.isPresent() && !optional.get().equalsIgnoreCase("NULL")) {
                    v.getDefaultValue().setValue(optional.orElse(null));
                }
                list.add(v);
            }
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("Error while selecting variables in database " + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Variable> selectVariable(Connection conn, String id) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("VariablesQuery selectVariable");
        }
        String sql = "SELECT col_type,col_for,col_values,col_defaultvalue FROM variables WHERE col_id = '" + id + "'";
        Optional<Variable> varOpt = Optional.empty();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                String type = rs.getString(COL_TYPE);
                String forFeature = rs.getString(COL_FOR);
                String values = rs.getString(COL_VALUES);
                String defaultValue = rs.getString(COL_DEFAULTVALUE);
                Variable v = new Variable(id, "plugins/SCore/variables/" + id + ".yml");
                VariableType variableType = VariableType.valueOf(type);
                v.getType().setValue(Optional.of(variableType));
                VariableForEnum variableForEnum = VariableForEnum.valueOf(forFeature);
                v.getForFeature().setValue(Optional.of(variableForEnum));
                HashMap<String, List<String>> entries = VariablesQuery.deconvertValues(values);
                v.setValues(entries);
                Optional<String> optional = Optional.ofNullable(defaultValue);
                if (optional.isPresent() && !optional.get().equalsIgnoreCase("NULL")) {
                    v.getDefaultValue().setValue(optional.orElse(null));
                }
                varOpt = Optional.of(v);
            }
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("Error while selecting variable in database " + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return varOpt;
    }
}

