/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.Instrument;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.MusicIntrusmentFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MusicInstrumentMeta;
import org.jetbrains.annotations.NotNull;

public class InstrumentFeatures
extends FeatureWithHisOwnEditor<InstrumentFeatures, InstrumentFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItem {
    private BooleanFeature enable;
    private MusicIntrusmentFeature instrument;

    public InstrumentFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.instrumentFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.enable = new BooleanFeature(this, false, FeatureSettingsSCore.enable);
        this.instrument = new MusicIntrusmentFeature(this, Optional.of(MusicInstrument.PONDER_GOAT_HORN), FeatureSettingsSCore.instrument);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            error.addAll(this.enable.load(plugin, section, isPremiumLoading));
            error.addAll(this.instrument.load(plugin, section, isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.enable.save(section);
        this.instrument.save(section);
    }

    @Override
    public InstrumentFeatures getValue() {
        return this;
    }

    @Override
    public InstrumentFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = this.isRequirePremium() && !this.isPremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = this.enable.getValue() != false ? "&7Enabled: &a&l\u2714" : "&7Enabled: &c&l\u2718";
        finalDescription[finalDescription.length - 1] = ((Optional)this.instrument.getValue()).isPresent() && Registry.INSTRUMENT.getKey((Keyed)((MusicInstrument)((Optional)this.instrument.getValue()).get())) != null ? "&7Instrument: &e" + Registry.INSTRUMENT.getKey((Keyed)((MusicInstrument)((Optional)this.instrument.getValue()).get())).getKey() : "&7Instrument: &cNONE";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public InstrumentFeatures clone(FeatureParentInterface newParent) {
        InstrumentFeatures dropFeatures = new InstrumentFeatures(newParent);
        dropFeatures.setEnable(this.enable.clone(dropFeatures));
        dropFeatures.setInstrument(this.instrument.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.enable);
        features.add(this.instrument);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof InstrumentFeatures)) continue;
            InstrumentFeatures dropFeatures = (InstrumentFeatures)feature;
            dropFeatures.setEnable(this.enable);
            dropFeatures.setInstrument(this.instrument);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v20Plus();
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return args.getMeta() instanceof MusicInstrumentMeta;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        ItemMeta meta = args.getMeta();
        try {
            if (meta instanceof MusicInstrumentMeta && this.getEnable().getValue().booleanValue()) {
                MusicInstrumentMeta bmeta = (MusicInstrumentMeta)meta;
                if (((Optional)this.getInstrument().getValue()).isPresent()) {
                    bmeta.setInstrument((MusicInstrument)((Optional)this.getInstrument().getValue()).get());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        SsomarDev.testMsg("SCORE DEBUG - InstrumentFeatures.loadFromItemMeta()", true);
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        SsomarDev.testMsg("SCORE DEBUG - InstrumentFeatures.loadFromItemMeta() 2", true);
        this.enable.setValue(true);
        MusicInstrumentMeta bmeta = (MusicInstrumentMeta)args.getMeta();
        if (bmeta.getInstrument() != null) {
            SsomarDev.testMsg("SCORE DEBUG - InstrumentFeatures.loadFromItemMeta() 3", true);
            this.getInstrument().setValue(Optional.ofNullable(bmeta.getInstrument()));
        } else {
            SsomarDev.testMsg("SCORE DEBUG - InstrumentFeatures.loadFromItemMeta() 4 NO INSTRUMENT", true);
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.INSTRUMENT;
    }

    @Generated
    public BooleanFeature getEnable() {
        return this.enable;
    }

    @Generated
    public MusicIntrusmentFeature getInstrument() {
        return this.instrument;
    }

    @Generated
    public void setEnable(BooleanFeature enable) {
        this.enable = enable;
    }

    @Generated
    public void setInstrument(MusicIntrusmentFeature instrument) {
        this.instrument = instrument;
    }
}

