/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.attributes.group;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.attributes.attribute.AttributeFullOptionsFeature;
import com.ssomar.score.features.custom.attributes.group.AttributesGroupFeatureEditor;
import com.ssomar.score.features.custom.attributes.group.AttributesGroupFeatureEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class AttributesGroupFeature
extends FeatureWithHisOwnEditor<AttributesGroupFeature, AttributesGroupFeature, AttributesGroupFeatureEditor, AttributesGroupFeatureEditorManager>
implements FeaturesGroup<AttributeFullOptionsFeature> {
    private Map<String, AttributeFullOptionsFeature> attributes;
    private BooleanFeature ignoreKeepDefaultAttributesFeature;
    private BooleanFeature keepDefaultAttributes;
    private boolean notSaveIfNoValue;
    private int premiumLimit = 5;

    public AttributesGroupFeature(FeatureParentInterface parent, boolean notSaveIfNoValue) {
        super(parent, FeatureSettingsSCore.attributes);
        this.notSaveIfNoValue = notSaveIfNoValue;
        this.reset();
    }

    @Override
    public void reset() {
        this.attributes = new LinkedHashMap<String, AttributeFullOptionsFeature>();
        this.keepDefaultAttributes = new BooleanFeature(this, false, FeatureSettingsSCore.keepDefaultAttributes);
        this.ignoreKeepDefaultAttributesFeature = new BooleanFeature(this, true, FeatureSettingsSCore.ignoreKeepDefaultAttributesFeature);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String attributeID : enchantmentsSection.getKeys(false)) {
                if (this.attributes.size() >= this.premiumLimit && !this.isPremium()) {
                    error.add("&cERROR, Couldn't load the Attribute of " + attributeID + " from config, &7&o" + this.getParent().getParentInfo() + " &6>> Because it requires the premium version to have more than 2 attributes !");
                    return error;
                }
                AttributeFullOptionsFeature attribute = new AttributeFullOptionsFeature((FeatureParentInterface)this, attributeID);
                List<String> subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.attributes.put(attributeID, attribute);
            }
        }
        error.addAll(this.keepDefaultAttributes.load(plugin, config, isPremiumLoading));
        error.addAll(this.ignoreKeepDefaultAttributesFeature.load(plugin, config, isPremiumLoading));
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfNoValue && this.attributes.size() == 0) {
            return;
        }
        ConfigurationSection attributesSection = config.createSection(this.getName());
        for (String enchantmentID : this.attributes.keySet()) {
            this.attributes.get(enchantmentID).save(attributesSection);
        }
        this.keepDefaultAttributes.save(config);
        this.ignoreKeepDefaultAttributesFeature.save(config);
        if (this.isSavingOnlyIfDiffDefault() && attributesSection.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public AttributesGroupFeature getValue() {
        return this;
    }

    @Override
    public AttributesGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = "&7&oAttribute(s) added: &e" + this.attributes.size();
        finalDescription[finalDescription.length - 1] = "&7&oKeep default attributes: &e" + this.keepDefaultAttributes.getValue();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public AttributeFullOptionsFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (AttributeFullOptionsFeature x : this.attributes.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public AttributesGroupFeature clone(FeatureParentInterface newParent) {
        AttributesGroupFeature eF = new AttributesGroupFeature(newParent, this.isNotSaveIfNoValue());
        LinkedHashMap<String, AttributeFullOptionsFeature> newAttributes = new LinkedHashMap<String, AttributeFullOptionsFeature>();
        for (String x : this.attributes.keySet()) {
            newAttributes.put(x, this.attributes.get(x).clone(eF));
        }
        eF.setAttributes(newAttributes);
        eF.setKeepDefaultAttributes(this.keepDefaultAttributes.clone(eF));
        eF.setIgnoreKeepDefaultAttributesFeature(this.ignoreKeepDefaultAttributesFeature.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>(this.attributes.values());
        features.add((AttributeFullOptionsFeature)((Object)this.keepDefaultAttributes));
        features.add((AttributeFullOptionsFeature)((Object)this.ignoreKeepDefaultAttributesFeature));
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof AttributesGroupFeature)) continue;
            AttributesGroupFeature eF = (AttributesGroupFeature)feature;
            eF.setAttributes(this.getAttributes());
            eF.setKeepDefaultAttributes(this.getKeepDefaultAttributes());
            eF.setIgnoreKeepDefaultAttributesFeature(this.getIgnoreKeepDefaultAttributesFeature());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        AttributesGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        if (!this.isPremium() && this.attributes.size() >= this.premiumLimit) {
            return;
        }
        String baseId = "attribute";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.attributes.containsKey(id)) continue;
            AttributeFullOptionsFeature eF = new AttributeFullOptionsFeature((FeatureParentInterface)this, id);
            this.attributes.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, AttributeFullOptionsFeature feature) {
        this.attributes.remove(feature.getId());
    }

    @Generated
    public Map<String, AttributeFullOptionsFeature> getAttributes() {
        return this.attributes;
    }

    @Generated
    public BooleanFeature getIgnoreKeepDefaultAttributesFeature() {
        return this.ignoreKeepDefaultAttributesFeature;
    }

    @Generated
    public BooleanFeature getKeepDefaultAttributes() {
        return this.keepDefaultAttributes;
    }

    @Generated
    public boolean isNotSaveIfNoValue() {
        return this.notSaveIfNoValue;
    }

    @Generated
    public int getPremiumLimit() {
        return this.premiumLimit;
    }

    @Generated
    public void setAttributes(Map<String, AttributeFullOptionsFeature> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setIgnoreKeepDefaultAttributesFeature(BooleanFeature ignoreKeepDefaultAttributesFeature) {
        this.ignoreKeepDefaultAttributesFeature = ignoreKeepDefaultAttributesFeature;
    }

    @Generated
    public void setKeepDefaultAttributes(BooleanFeature keepDefaultAttributes) {
        this.keepDefaultAttributes = keepDefaultAttributes;
    }

    @Generated
    public void setNotSaveIfNoValue(boolean notSaveIfNoValue) {
        this.notSaveIfNoValue = notSaveIfNoValue;
    }

    @Generated
    public void setPremiumLimit(int premiumLimit) {
        this.premiumLimit = premiumLimit;
    }
}

