/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.blocksAttacksFeatures.DamageReductionFeatures;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.features.types.list.ListDamageTypeFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import io.papermc.paper.datacomponent.item.blocksattacks.DamageReduction;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DamageReductionFeature
extends FeatureWithHisOwnEditor<DamageReductionFeature, DamageReductionFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private DoubleFeature baseDamageBlocked;
    private DoubleFeature factorDamageBlocked;
    private DoubleFeature horizontalBlockingAngle;
    private ListDamageTypeFeature damageTypes;
    private String id;

    public DamageReductionFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.damageReduction);
        this.id = id;
        this.reset();
    }

    public DamageReduction asDamageReduction() {
        return (DamageReduction)DamageReduction.damageReduction().base(((Double)((Optional)this.baseDamageBlocked.getValue()).get()).floatValue()).factor(((Double)((Optional)this.factorDamageBlocked.getValue()).get()).floatValue()).horizontalBlockingAngle(((Double)((Optional)this.horizontalBlockingAngle.getValue()).get()).floatValue()).type(this.damageTypes.asRegistryKeySet()).build();
    }

    public void fromDamageReduction(DamageReduction damageReduction) {
        this.baseDamageBlocked.setValue(Optional.of(Double.valueOf(damageReduction.base())));
        this.factorDamageBlocked.setValue(Optional.of(Double.valueOf(damageReduction.factor())));
        this.horizontalBlockingAngle.setValue(Optional.of(Double.valueOf(damageReduction.horizontalBlockingAngle())));
        if (damageReduction.type() != null) {
            this.damageTypes.fromRegistryKeySet((RegistryKeySet<DamageType>)damageReduction.type());
        }
        SsomarDev.testMsg("\u00a76[SC] DamageReductionFeature loaded from DamageReduction: " + this, true);
        SsomarDev.testMsg("\u00a76[SC] type: " + damageReduction.type(), true);
    }

    @Override
    public void reset() {
        this.baseDamageBlocked = new DoubleFeature(this, Optional.of(1.0), FeatureSettingsSCore.baseDamageBlocked);
        this.factorDamageBlocked = new DoubleFeature(this, Optional.of(1.0), FeatureSettingsSCore.factorDamageBlocked);
        this.horizontalBlockingAngle = new DoubleFeature(this, Optional.of(90.0), FeatureSettingsSCore.horizontalBlockingAngle);
        this.damageTypes = new ListDamageTypeFeature(this, new ArrayList<DamageType>(), FeatureSettingsSCore.damageTypes);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection section = config.getConfigurationSection(this.id);
            errors.addAll(this.baseDamageBlocked.load(plugin, section, isPremiumLoading));
            errors.addAll(this.factorDamageBlocked.load(plugin, section, isPremiumLoading));
            errors.addAll(this.horizontalBlockingAngle.load(plugin, section, isPremiumLoading));
            if (((Optional)this.horizontalBlockingAngle.getValue()).orElse(90.0) <= 0.0) {
                errors.add("&cERROR, The horizontal blocking angle must be greater than 0 &7&o" + this.getParent().getParentInfo());
                this.horizontalBlockingAngle.setValue(Optional.of(90.0));
            }
            errors.addAll(this.damageTypes.load(plugin, section, isPremiumLoading));
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection section = config.createSection(this.id);
        this.baseDamageBlocked.save(section);
        this.factorDamageBlocked.save(section);
        this.horizontalBlockingAngle.save(section);
        this.damageTypes.save(section);
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.id, null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.id, StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public DamageReductionFeature getValue() {
        return this;
    }

    @Override
    public DamageReductionFeature initItemParentEditor(GUI gui, int slot) {
        int len = 5;
        String[] finalDescription = new String[this.getEditorDescription().length + len];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - len] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - --len] = "&7Base Damage Blocked: &e" + ((Optional)this.baseDamageBlocked.getValue()).get();
        finalDescription[finalDescription.length - --len] = "&7Factor Damage Blocked: &e" + ((Optional)this.factorDamageBlocked.getValue()).get();
        finalDescription[finalDescription.length - --len] = "&7Horizontal Blocking Angle: &e" + ((Optional)this.horizontalBlockingAngle.getValue()).get();
        finalDescription[finalDescription.length - --len] = "&7Damage Types: &e" + this.damageTypes.getValues();
        --len;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public DamageReductionFeature clone(FeatureParentInterface newParent) {
        DamageReductionFeature newReduction = new DamageReductionFeature(newParent, this.id);
        newReduction.setBaseDamageBlocked(this.baseDamageBlocked.clone(newReduction));
        newReduction.setFactorDamageBlocked(this.factorDamageBlocked.clone(newReduction));
        newReduction.setHorizontalBlockingAngle(this.horizontalBlockingAngle.clone(newReduction));
        newReduction.setDamageTypes(this.damageTypes.clone(newReduction));
        return newReduction;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.baseDamageBlocked);
        features.add(this.factorDamageBlocked);
        features.add(this.horizontalBlockingAngle);
        features.add(this.damageTypes);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof DamageReductionFeature)) continue;
            DamageReductionFeature hiders = (DamageReductionFeature)feature;
            hiders.setBaseDamageBlocked(this.baseDamageBlocked);
            hiders.setFactorDamageBlocked(this.factorDamageBlocked);
            hiders.setHorizontalBlockingAngle(this.horizontalBlockingAngle);
            hiders.setDamageTypes(this.damageTypes);
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public DoubleFeature getBaseDamageBlocked() {
        return this.baseDamageBlocked;
    }

    @Generated
    public DoubleFeature getFactorDamageBlocked() {
        return this.factorDamageBlocked;
    }

    @Generated
    public DoubleFeature getHorizontalBlockingAngle() {
        return this.horizontalBlockingAngle;
    }

    @Generated
    public ListDamageTypeFeature getDamageTypes() {
        return this.damageTypes;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setBaseDamageBlocked(DoubleFeature baseDamageBlocked) {
        this.baseDamageBlocked = baseDamageBlocked;
    }

    @Generated
    public void setFactorDamageBlocked(DoubleFeature factorDamageBlocked) {
        this.factorDamageBlocked = factorDamageBlocked;
    }

    @Generated
    public void setHorizontalBlockingAngle(DoubleFeature horizontalBlockingAngle) {
        this.horizontalBlockingAngle = horizontalBlockingAngle;
    }

    @Generated
    public void setDamageTypes(ListDamageTypeFeature damageTypes) {
        this.damageTypes = damageTypes;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

