/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.brewingstand;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.BrewingStand;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BrewingStandFeatures
extends FeatureWithHisOwnEditor<BrewingStandFeatures, BrewingStandFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private DoubleFeature brewingStandSpeed;

    public BrewingStandFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.brewingStandFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.brewingStandSpeed = new DoubleFeature(this, Optional.of(1.0), FeatureSettingsSCore.brewingStandSpeed);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection containerFeaturesSection = config.getConfigurationSection(this.getName());
            error.addAll(this.brewingStandSpeed.load(plugin, containerFeaturesSection, isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection furnaceFeaturesSection = config.createSection(this.getName());
        this.brewingStandSpeed.save(furnaceFeaturesSection);
    }

    @Override
    public BrewingStandFeatures getValue() {
        return this;
    }

    @Override
    public BrewingStandFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7Brewing Stand speed: &e" + ((Optional)this.brewingStandSpeed.getValue()).get();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public BrewingStandFeatures clone(FeatureParentInterface newParent) {
        BrewingStandFeatures eF = new BrewingStandFeatures(newParent);
        eF.brewingStandSpeed = this.brewingStandSpeed.clone(eF);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.brewingStandSpeed);
        return features;
    }

    public boolean canBeApplied(BlockData blockData) {
        return SCore.is1v17Plus() && blockData instanceof BrewingStand;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof BrewingStandFeatures)) continue;
            BrewingStandFeatures eF = (BrewingStandFeatures)feature;
            eF.setBrewingStandSpeed(this.brewingStandSpeed);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public DoubleFeature getBrewingStandSpeed() {
        return this.brewingStandSpeed;
    }

    @Generated
    public void setBrewingStandSpeed(DoubleFeature brewingStandSpeed) {
        this.brewingStandSpeed = brewingStandSpeed;
    }
}

