/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.entity.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.entity.EntityConditionFeature;
import com.ssomar.score.features.custom.conditions.entity.EntityConditionRequest;
import com.ssomar.score.features.types.NumberConditionFeature;
import com.ssomar.score.utils.strings.StringCalculation;
import java.util.Optional;
import org.bukkit.entity.Entity;

public class IfEntityAge
extends EntityConditionFeature<NumberConditionFeature, IfEntityAge> {
    public IfEntityAge(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifEntityAge);
    }

    @Override
    public boolean verifCondition(EntityConditionRequest request) {
        if (this.hasCondition()) {
            Entity entity = request.getEntity();
            int age = entity.getTicksLived();
            if (!StringCalculation.calculation(((NumberConditionFeature)this.getCondition()).getValue(request.getPlayerOpt(), request.getSp()).get(), age)) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfEntityAge getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new NumberConditionFeature(this.getParent(), FeatureSettingsSCore.ifEntityAge));
    }

    @Override
    public boolean hasCondition() {
        return ((Optional)((NumberConditionFeature)this.getCondition()).getValue()).isPresent();
    }

    @Override
    public IfEntityAge getNewInstance(FeatureParentInterface parent) {
        return new IfEntityAge(parent);
    }
}

