/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.entity.condition;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.entity.EntityConditionFeature;
import com.ssomar.score.features.custom.conditions.entity.EntityConditionRequest;
import com.ssomar.score.features.types.list.ListUncoloredStringFeature;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class IfEntityInRegion
extends EntityConditionFeature<ListUncoloredStringFeature, IfEntityInRegion> {
    public IfEntityInRegion(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifEntityInRegion);
    }

    @Override
    public boolean verifCondition(EntityConditionRequest request) {
        if (this.hasCondition()) {
            if ((SCore.hasWorldEdit || SCore.hasFastAsyncWorldEdit) && SCore.hasWorldGuard) {
                Entity entity = request.getEntity();
                com.sk89q.worldedit.util.Location loc = BukkitAdapter.adapt((Location)entity.getLocation());
                RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
                RegionManager regions = container.get(BukkitAdapter.adapt((World)entity.getWorld()));
                if (regions == null) {
                    this.runInvalidCondition(request);
                    return false;
                }
                ApplicableRegionSet set = regions.getApplicableRegions(loc.toVector().toBlockPoint());
                for (String name : ((ListUncoloredStringFeature)this.getCondition()).getValue(request.getSp())) {
                    for (ProtectedRegion region : set) {
                        if (!region.getId().equalsIgnoreCase(name)) continue;
                        return true;
                    }
                }
                this.runInvalidCondition(request);
                return false;
            }
            this.runInvalidCondition(request);
            return false;
        }
        return true;
    }

    @Override
    public void subReset() {
        this.setCondition(new ListUncoloredStringFeature(this.getParent(), new ArrayList<String>(), FeatureSettingsSCore.ifEntityInRegion, Optional.empty()));
    }

    @Override
    public boolean hasCondition() {
        return !((ListUncoloredStringFeature)this.getCondition()).getValue().isEmpty();
    }

    @Override
    public IfEntityInRegion getNewInstance(FeatureParentInterface newParent) {
        return new IfEntityInRegion(newParent);
    }

    @Override
    public IfEntityInRegion getValue() {
        return this;
    }
}

