/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.entity.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.entity.EntityConditionFeature;
import com.ssomar.score.features.custom.conditions.entity.EntityConditionRequest;
import com.ssomar.score.features.types.list.ListUncoloredStringFeature;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityDamageEvent;

public class IfEntityLastDamageCause
extends EntityConditionFeature<ListUncoloredStringFeature, IfEntityLastDamageCause> {
    public IfEntityLastDamageCause(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifEntityLastDamageCause);
    }

    @Override
    public boolean verifCondition(EntityConditionRequest request) {
        if (this.hasCondition()) {
            Entity entity = request.getEntity();
            EntityDamageEvent lastDamageCause = entity.getLastDamageCause();
            if (lastDamageCause == null) {
                this.runInvalidCondition(request);
                return false;
            }
            String causeType = lastDamageCause.getCause().name();
            boolean found = false;
            for (String cause : ((ListUncoloredStringFeature)this.getCondition()).getValue(request.getSp())) {
                if (!causeType.equalsIgnoreCase(cause)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfEntityLastDamageCause getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new ListUncoloredStringFeature(this.getParent(), new ArrayList<String>(), FeatureSettingsSCore.ifEntityLastDamageCause, Optional.empty()));
    }

    @Override
    public boolean hasCondition() {
        return ((ListUncoloredStringFeature)this.getCondition()).getValue().size() > 0;
    }

    @Override
    public IfEntityLastDamageCause getNewInstance(FeatureParentInterface parent) {
        return new IfEntityLastDamageCause(parent);
    }
}

