/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.player.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionFeature;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionRequest;
import com.ssomar.score.features.types.NumberConditionFeature;
import com.ssomar.score.utils.strings.StringCalculation;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class IfPlayerBedSpawnLocationZ
extends PlayerConditionFeature<NumberConditionFeature, IfPlayerBedSpawnLocationZ> {
    public IfPlayerBedSpawnLocationZ(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifPlayerBedSpawnLocationZ);
    }

    @Override
    public boolean verifCondition(PlayerConditionRequest request) {
        if (this.hasCondition()) {
            Player player = request.getPlayer();
            Location bedSpawn = player.getBedSpawnLocation();
            if (bedSpawn == null) {
                this.runInvalidCondition(request);
                return false;
            }
            double z = bedSpawn.getZ();
            if (!StringCalculation.calculation(((NumberConditionFeature)this.getCondition()).getValue(Optional.of(player), request.getSp()).get(), z)) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfPlayerBedSpawnLocationZ getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new NumberConditionFeature(this.getParent(), FeatureSettingsSCore.ifPlayerBedSpawnLocationZ));
    }

    @Override
    public boolean hasCondition() {
        return ((Optional)((NumberConditionFeature)this.getCondition()).getValue()).isPresent();
    }

    @Override
    public IfPlayerBedSpawnLocationZ getNewInstance(FeatureParentInterface parent) {
        return new IfPlayerBedSpawnLocationZ(parent);
    }
}

