/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.player.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionFeature;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionRequest;
import com.ssomar.score.features.types.list.ListEntityTypeFeature;
import java.util.ArrayList;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class IfPlayerNotMounts
extends PlayerConditionFeature<ListEntityTypeFeature, IfPlayerNotMounts> {
    public IfPlayerNotMounts(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifPlayerNotMounts);
    }

    @Override
    public boolean verifCondition(PlayerConditionRequest request) {
        if (this.hasCondition()) {
            Player player = request.getPlayer();
            boolean error = false;
            Entity vehicle = player.getVehicle();
            if (vehicle != null && ((ListEntityTypeFeature)this.getCondition()).getValue().contains(vehicle.getType())) {
                error = true;
            }
            if (error) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfPlayerNotMounts getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new ListEntityTypeFeature(this, new ArrayList<EntityType>(), FeatureSettingsSCore.ifPlayerNotMounts));
    }

    @Override
    public boolean hasCondition() {
        return ((ListEntityTypeFeature)this.getCondition()).getValue().size() > 0;
    }

    @Override
    public IfPlayerNotMounts getNewInstance(FeatureParentInterface parent) {
        return new IfPlayerNotMounts(parent);
    }
}

