/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.player.parent;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionFeature;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionRequest;
import com.ssomar.score.features.custom.conditions.player.condition.IfBlocking;
import com.ssomar.score.features.custom.conditions.player.condition.IfCanBreakTargetedBlock;
import com.ssomar.score.features.custom.conditions.player.condition.IfCursorDistance;
import com.ssomar.score.features.custom.conditions.player.condition.IfFlying;
import com.ssomar.score.features.custom.conditions.player.condition.IfGamemode;
import com.ssomar.score.features.custom.conditions.player.condition.IfGliding;
import com.ssomar.score.features.custom.conditions.player.condition.IfHasExecutableItems;
import com.ssomar.score.features.custom.conditions.player.condition.IfHasItems;
import com.ssomar.score.features.custom.conditions.player.condition.IfHasNotExecutableItems;
import com.ssomar.score.features.custom.conditions.player.condition.IfHasNotItems;
import com.ssomar.score.features.custom.conditions.player.condition.IfHasPermission;
import com.ssomar.score.features.custom.conditions.player.condition.IfHasTag;
import com.ssomar.score.features.custom.conditions.player.condition.IfInBiome;
import com.ssomar.score.features.custom.conditions.player.condition.IfInRegion;
import com.ssomar.score.features.custom.conditions.player.condition.IfInWorld;
import com.ssomar.score.features.custom.conditions.player.condition.IfIsInTheAir;
import com.ssomar.score.features.custom.conditions.player.condition.IfIsInTheBlock;
import com.ssomar.score.features.custom.conditions.player.condition.IfIsNotInTheAir;
import com.ssomar.score.features.custom.conditions.player.condition.IfIsNotInTheBlock;
import com.ssomar.score.features.custom.conditions.player.condition.IfIsNotOnFire;
import com.ssomar.score.features.custom.conditions.player.condition.IfIsNotOnTheBlock;
import com.ssomar.score.features.custom.conditions.player.condition.IfIsOnFire;
import com.ssomar.score.features.custom.conditions.player.condition.IfIsOnTheBlock;
import com.ssomar.score.features.custom.conditions.player.condition.IfLightLevel;
import com.ssomar.score.features.custom.conditions.player.condition.IfNotBlocking;
import com.ssomar.score.features.custom.conditions.player.condition.IfNotFlying;
import com.ssomar.score.features.custom.conditions.player.condition.IfNotGliding;
import com.ssomar.score.features.custom.conditions.player.condition.IfNotHasPermission;
import com.ssomar.score.features.custom.conditions.player.condition.IfNotHasTag;
import com.ssomar.score.features.custom.conditions.player.condition.IfNotInBiome;
import com.ssomar.score.features.custom.conditions.player.condition.IfNotInRegion;
import com.ssomar.score.features.custom.conditions.player.condition.IfNotInWorld;
import com.ssomar.score.features.custom.conditions.player.condition.IfNotSneaking;
import com.ssomar.score.features.custom.conditions.player.condition.IfNotSprinting;
import com.ssomar.score.features.custom.conditions.player.condition.IfNotStunned;
import com.ssomar.score.features.custom.conditions.player.condition.IfNotSwimming;
import com.ssomar.score.features.custom.conditions.player.condition.IfNotTargetBlock;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerBedSpawnLocationX;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerBedSpawnLocationY;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerBedSpawnLocationZ;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerEXP;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerFoodLevel;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerHasEffect;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerHasEffectEquals;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerHealth;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerIsRiding;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerLastDamage;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerLevel;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerMounts;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerMustBeInHisTown;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerMustBeOnHisClaim;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerMustBeOnHisClaimOrWilderness;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerMustBeOnHisIsland;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerMustBeOnHisPlot;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerNotHasEffect;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerNotMounts;
import com.ssomar.score.features.custom.conditions.player.condition.IfPlayerOxygen;
import com.ssomar.score.features.custom.conditions.player.condition.IfPosX;
import com.ssomar.score.features.custom.conditions.player.condition.IfPosY;
import com.ssomar.score.features.custom.conditions.player.condition.IfPosZ;
import com.ssomar.score.features.custom.conditions.player.condition.IfSneaking;
import com.ssomar.score.features.custom.conditions.player.condition.IfSprinting;
import com.ssomar.score.features.custom.conditions.player.condition.IfStunned;
import com.ssomar.score.features.custom.conditions.player.condition.IfSwimming;
import com.ssomar.score.features.custom.conditions.player.condition.IfTargetBlock;
import com.ssomar.score.features.custom.conditions.player.parent.PlayerConditionsFeatureEditor;
import com.ssomar.score.features.custom.conditions.player.parent.PlayerConditionsFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerConditionsFeature
extends FeatureWithHisOwnEditor<PlayerConditionsFeature, PlayerConditionsFeature, PlayerConditionsFeatureEditor, PlayerConditionsFeatureEditorManager> {
    private List<PlayerConditionFeature> conditions;

    public PlayerConditionsFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.reset();
    }

    @Override
    public void reset() {
        this.conditions = new ArrayList<PlayerConditionFeature>();
        this.conditions.add(new IfSneaking(this));
        this.conditions.add(new IfNotSneaking(this));
        this.conditions.add(new IfSprinting(this));
        this.conditions.add(new IfNotSprinting(this));
        this.conditions.add(new IfFlying(this));
        this.conditions.add(new IfNotFlying(this));
        this.conditions.add(new IfBlocking(this));
        this.conditions.add(new IfNotBlocking(this));
        this.conditions.add(new IfGliding(this));
        this.conditions.add(new IfNotGliding(this));
        if (!SCore.is1v12Less()) {
            this.conditions.add(new IfSwimming(this));
            this.conditions.add(new IfNotSwimming(this));
        }
        this.conditions.add(new IfStunned(this));
        this.conditions.add(new IfNotStunned(this));
        this.conditions.add(new IfIsOnFire(this));
        this.conditions.add(new IfIsNotOnFire(this));
        this.conditions.add(new IfIsInTheAir(this));
        this.conditions.add(new IfIsNotInTheAir(this));
        this.conditions.add(new IfPlayerMustBeInHisTown(this));
        this.conditions.add(new IfPlayerMustBeOnHisClaim(this));
        this.conditions.add(new IfPlayerMustBeOnHisClaimOrWilderness(this));
        this.conditions.add(new IfPlayerMustBeOnHisIsland(this));
        this.conditions.add(new IfPlayerMustBeOnHisPlot(this));
        this.conditions.add(new IfCanBreakTargetedBlock(this));
        this.conditions.add(new IfPlayerIsRiding(this));
        this.conditions.add(new IfCursorDistance(this));
        this.conditions.add(new IfLightLevel(this));
        this.conditions.add(new IfPlayerEXP(this));
        this.conditions.add(new IfPlayerLevel(this));
        this.conditions.add(new IfPlayerFoodLevel(this));
        this.conditions.add(new IfPlayerHealth(this));
        this.conditions.add(new IfPlayerLastDamage(this));
        this.conditions.add(new IfPlayerOxygen(this));
        this.conditions.add(new IfPlayerBedSpawnLocationX(this));
        this.conditions.add(new IfPlayerBedSpawnLocationY(this));
        this.conditions.add(new IfPlayerBedSpawnLocationZ(this));
        this.conditions.add(new IfPosX(this));
        this.conditions.add(new IfPosY(this));
        this.conditions.add(new IfPosZ(this));
        this.conditions.add(new IfGamemode(this));
        this.conditions.add(new IfHasPermission(this));
        this.conditions.add(new IfNotHasPermission(this));
        this.conditions.add(new IfHasTag(this));
        this.conditions.add(new IfNotHasTag(this));
        this.conditions.add(new IfTargetBlock(this));
        this.conditions.add(new IfNotTargetBlock(this));
        this.conditions.add(new IfIsInTheBlock(this));
        this.conditions.add(new IfIsNotInTheBlock(this));
        this.conditions.add(new IfIsOnTheBlock(this));
        this.conditions.add(new IfIsNotOnTheBlock(this));
        this.conditions.add(new IfPlayerMounts(this));
        this.conditions.add(new IfPlayerNotMounts(this));
        this.conditions.add(new IfInBiome(this));
        this.conditions.add(new IfNotInBiome(this));
        this.conditions.add(new IfInRegion(this));
        this.conditions.add(new IfNotInRegion(this));
        this.conditions.add(new IfInWorld(this));
        this.conditions.add(new IfNotInWorld(this));
        this.conditions.add(new IfPlayerHasEffect(this));
        this.conditions.add(new IfPlayerHasEffectEquals(this));
        this.conditions.add(new IfPlayerNotHasEffect(this));
        this.conditions.add(new IfHasExecutableItems(this));
        this.conditions.add(new IfHasNotExecutableItems(this));
        this.conditions.add(new IfHasItems(this));
        this.conditions.add(new IfHasNotItems(this));
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            for (PlayerConditionFeature condition : this.conditions) {
                error.addAll(condition.load(plugin, section, isPremiumLoading));
            }
        }
        return error;
    }

    public boolean verifConditions(Player player, Optional<Player> launcher, SendMessage messageSender, @Nullable Event event) {
        for (PlayerConditionFeature condition : this.conditions) {
            PlayerConditionRequest args;
            if (condition.verifCondition(args = new PlayerConditionRequest(player, launcher, messageSender.getSp(), event))) continue;
            if (messageSender != null && launcher.isPresent()) {
                for (String error : args.getErrorsFinal()) {
                    messageSender.sendMessage(launcher.get(), error);
                }
            }
            SsomarDev.testMsg("Error in condition: " + condition.getName(), true);
            return false;
        }
        return true;
    }

    public boolean verifConditions(Player player, List<String> errors, @Nullable StringPlaceholder placeholder) {
        if (placeholder == null) {
            placeholder = new StringPlaceholder();
        }
        PlayerConditionRequest args = new PlayerConditionRequest(player, Optional.empty(), placeholder.setPlayerPlcHldr(player.getUniqueId()), null);
        for (PlayerConditionFeature condition : this.conditions) {
            if (condition.verifCondition(args)) continue;
            errors.addAll(args.getErrorsFinal());
            return false;
        }
        return true;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        for (PlayerConditionFeature condition : this.conditions) {
            condition.save(section);
        }
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public PlayerConditionsFeature getValue() {
        return this;
    }

    @Override
    public PlayerConditionsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = "&7Player condition(s) enabled: &e" + this.getPlayerConditionEnabledCount();
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    public int getPlayerConditionEnabledCount() {
        int i = 0;
        for (PlayerConditionFeature condition : this.conditions) {
            if (!condition.hasCondition()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public PlayerConditionsFeature clone(FeatureParentInterface newParent) {
        PlayerConditionsFeature clone = new PlayerConditionsFeature(newParent, this.getFeatureSettings());
        ArrayList<PlayerConditionFeature> clones = new ArrayList<PlayerConditionFeature>();
        for (PlayerConditionFeature condition : this.conditions) {
            clones.add((PlayerConditionFeature)condition.clone(clone));
        }
        clone.setConditions(clones);
        return clone;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.conditions);
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof PlayerConditionsFeature) || !feature.getName().equals(this.getName())) continue;
            PlayerConditionsFeature bCF = (PlayerConditionsFeature)feature;
            ArrayList<PlayerConditionFeature> clones = new ArrayList<PlayerConditionFeature>();
            for (PlayerConditionFeature condition : this.conditions) {
                clones.add(condition);
            }
            bCF.setConditions(clones);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        PlayerConditionsFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public List<PlayerConditionFeature> getConditions() {
        return this.conditions;
    }

    @Generated
    public void setConditions(List<PlayerConditionFeature> conditions) {
        this.conditions = conditions;
    }
}

