/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.detailedslots;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.detailedslots.DetailedSlotsEditor;
import com.ssomar.score.features.custom.detailedslots.DetailedSlotsEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DetailedSlots
extends FeatureWithHisOwnEditor<DetailedSlots, DetailedSlots, DetailedSlotsEditor, DetailedSlotsEditorManager> {
    private List<Integer> slots;

    public DetailedSlots(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.detailedSlots);
        this.reset();
    }

    @Override
    public void reset() {
        this.slots = new ArrayList<Integer>();
        this.slots.add(-1);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        this.slots = new ArrayList<Integer>();
        for (String s : config.getStringList(this.getName())) {
            try {
                this.slots.add(Integer.valueOf(s));
            }
            catch (Exception exception) {}
        }
        if (this.slots.isEmpty()) {
            for (int i = -1; i <= 40; ++i) {
                this.slots.add(i);
            }
        }
        return error;
    }

    public boolean verifSlot(int slot, boolean mainHand) {
        if (!this.slots.contains(slot)) {
            if (mainHand) {
                return this.slots.contains(-1);
            }
            return false;
        }
        return true;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (this.slots.size() == 42) {
            config.set(this.getName(), new ArrayList());
        } else {
            config.set(this.getName(), this.slots);
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public DetailedSlots getValue() {
        return this;
    }

    @Override
    public DetailedSlots initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7Slot(s) enabled: &e" + this.slots.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public DetailedSlots clone(FeatureParentInterface newParent) {
        DetailedSlots dropFeatures = new DetailedSlots(newParent);
        dropFeatures.setSlots(new ArrayList<Integer>(this.slots));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Collections.emptyList());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof DetailedSlots)) continue;
            DetailedSlots hiders = (DetailedSlots)feature;
            hiders.setSlots(this.slots);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        DetailedSlotsEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public List<Integer> getSlots() {
        return this.slots;
    }

    @Generated
    public void setSlots(List<Integer> slots) {
        this.slots = slots;
    }
}

