/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.firework;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.firework.explosion.group.FireworkExplosionGroupFeature;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.FireworkEffectTypeFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.list.ListBukkitColorFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.projectiles.features.SProjectileFeatureInterface;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class FireworkFeatures
extends FeatureWithHisOwnEditor<FireworkFeatures, FireworkFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements SProjectileFeatureInterface,
FeatureForItem {
    private IntegerFeature lifeTime;
    private FireworkExplosionGroupFeature explosions;
    private ListBukkitColorFeature colors;
    private ListBukkitColorFeature fadeColors;
    private FireworkEffectTypeFeature type;

    public FireworkFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.fireworkFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.lifeTime = new IntegerFeature(this, Optional.empty(), FeatureSettingsSCore.lifeTime);
        this.explosions = new FireworkExplosionGroupFeature((FeatureParentInterface)this, true);
        this.type = new FireworkEffectTypeFeature(this, Optional.empty(), FeatureSettingsSCore.type);
        this.colors = new ListBukkitColorFeature((FeatureParentInterface)this, new ArrayList<Color>(), FeatureSettingsSCore.colors, Optional.empty());
        this.fadeColors = new ListBukkitColorFeature((FeatureParentInterface)this, new ArrayList<Color>(), FeatureSettingsSCore.fadeColors, Optional.empty());
    }

    @Override
    public void transformTheProjectile(Entity e, Player launcher, Material materialLaunched) {
        if (e instanceof Firework) {
            Firework firework = (Firework)e;
            if (((Optional)this.lifeTime.getValue()).isPresent()) {
                firework.setMaxLife(((Integer)((Optional)this.lifeTime.getValue()).get()).intValue());
            }
            FireworkMeta meta = firework.getFireworkMeta();
            if (!this.colors.getValue().isEmpty() && ((Optional)this.type.getValue()).isPresent()) {
                FireworkEffect.Builder builder = FireworkEffect.builder();
                builder.withTrail().withFlicker();
                if (!this.fadeColors.getValue().isEmpty()) {
                    builder.withFade((Iterable)this.fadeColors.getValue());
                }
                builder.with((FireworkEffect.Type)((Optional)this.type.getValue()).get());
                builder.withColor((Iterable)this.colors.getValue());
                meta.addEffect(builder.build());
                firework.setFireworkMeta(meta);
            }
            this.explosions.transformTheProjectile((Entity)firework, launcher, materialLaunched);
        }
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            errors.addAll(this.lifeTime.load(plugin, section, isPremiumLoading));
            errors.addAll(this.explosions.load(plugin, section, isPremiumLoading));
            errors.addAll(this.colors.load(plugin, section, isPremiumLoading));
            errors.addAll(this.fadeColors.load(plugin, section, isPremiumLoading));
            errors.addAll(this.type.load(plugin, section, isPremiumLoading));
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.lifeTime.save(section);
        this.explosions.save(section);
        this.colors.save(section);
        this.fadeColors.save(section);
        this.type.save(section);
    }

    @Override
    public FireworkFeatures getValue() {
        return this;
    }

    @Override
    public FireworkFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 1];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public FireworkFeatures clone(FeatureParentInterface newParent) {
        FireworkFeatures clone = new FireworkFeatures(newParent);
        clone.setLifeTime(this.lifeTime.clone(clone));
        clone.setExplosions(this.explosions.clone(clone));
        clone.setColors(this.colors.clone(clone));
        clone.setFadeColors(this.fadeColors.clone(clone));
        clone.setType(this.type.clone(clone));
        return clone;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.lifeTime);
        features.add(this.explosions);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof FireworkFeatures) || !feature.getName().equals(this.getName())) continue;
            FireworkFeatures hiders = (FireworkFeatures)feature;
            hiders.setLifeTime(this.lifeTime);
            hiders.setExplosions(this.explosions);
            hiders.setColors(this.colors);
            hiders.setFadeColors(this.fadeColors);
            hiders.setType(this.type);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openBackEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean isAvailable() {
        return !SCore.is1v11Less();
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return args.getMeta() instanceof FireworkMeta;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        ItemMeta itemMeta = args.getMeta();
        if (itemMeta instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)itemMeta;
            if (((Optional)this.lifeTime.getValue()).isPresent()) {
                fireworkMeta.setPower(((Integer)((Optional)this.lifeTime.getValue()).get()).intValue());
            }
            if (!this.colors.getValue().isEmpty() && ((Optional)this.type.getValue()).isPresent()) {
                FireworkEffect.Builder builder = FireworkEffect.builder();
                builder.withTrail().withFlicker();
                if (!this.fadeColors.getValue().isEmpty()) {
                    builder.withFade((Iterable)this.fadeColors.getValue());
                }
                builder.with((FireworkEffect.Type)((Optional)this.type.getValue()).get());
                builder.withColor((Iterable)this.colors.getValue());
                fireworkMeta.addEffect(builder.build());
            }
            this.explosions.applyOnItemMeta(args);
        }
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        ItemMeta itemMeta = args.getMeta();
        if (itemMeta instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)itemMeta;
            if (fireworkMeta.hasPower()) {
                this.lifeTime.setValue(Optional.of(fireworkMeta.getPower()));
            }
            this.explosions.loadFromItemMeta(args);
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.FIREWORK;
    }

    @Generated
    public IntegerFeature getLifeTime() {
        return this.lifeTime;
    }

    @Generated
    public FireworkExplosionGroupFeature getExplosions() {
        return this.explosions;
    }

    @Generated
    public ListBukkitColorFeature getColors() {
        return this.colors;
    }

    @Generated
    public ListBukkitColorFeature getFadeColors() {
        return this.fadeColors;
    }

    @Generated
    public FireworkEffectTypeFeature getType() {
        return this.type;
    }

    @Generated
    public void setLifeTime(IntegerFeature lifeTime) {
        this.lifeTime = lifeTime;
    }

    @Generated
    public void setExplosions(FireworkExplosionGroupFeature explosions) {
        this.explosions = explosions;
    }

    @Generated
    public void setColors(ListBukkitColorFeature colors) {
        this.colors = colors;
    }

    @Generated
    public void setFadeColors(ListBukkitColorFeature fadeColors) {
        this.fadeColors = fadeColors;
    }

    @Generated
    public void setType(FireworkEffectTypeFeature type) {
        this.type = type;
    }
}

