/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.foodFeatures;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureForItemNewPaperComponents;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.foodFeatures.FoodFeaturesPaper;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.jetbrains.annotations.NotNull;

public class FoodFeatures
extends FeatureWithHisOwnEditor<FoodFeatures, FoodFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItemNewPaperComponents {
    private IntegerFeature nutrition;
    private IntegerFeature saturation;
    private BooleanFeature isMeat;
    private BooleanFeature canAlwaysEat;
    private IntegerFeature eatSeconds;

    public FoodFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.foodFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.nutrition = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.nutrition);
        this.saturation = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.saturation);
        this.isMeat = new BooleanFeature(this, false, FeatureSettingsSCore.isMeat);
        this.canAlwaysEat = new BooleanFeature(this, false, FeatureSettingsSCore.canAlwaysEat);
        this.eatSeconds = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.eatSeconds);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            errors.addAll(this.nutrition.load(plugin, section, isPremiumLoading));
            errors.addAll(this.saturation.load(plugin, section, isPremiumLoading));
            errors.addAll(this.isMeat.load(plugin, section, isPremiumLoading));
            errors.addAll(this.canAlwaysEat.load(plugin, section, isPremiumLoading));
            if (!SCore.is1v21v2Plus()) {
                errors.addAll(this.eatSeconds.load(plugin, section, isPremiumLoading));
            }
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        for (FeatureInterface feature : this.getFeatures()) {
            feature.save(section);
        }
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public FoodFeatures getValue() {
        return this;
    }

    @Override
    public FoodFeatures initItemParentEditor(GUI gui, int slot) {
        int len = 5;
        if (!SCore.is1v21v2Plus()) {
            len = 6;
        }
        String[] finalDescription = new String[this.getEditorDescription().length + len];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - len] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - --len] = this.isMeat.getValue() != false ? "&7IsMeat: &a&l\u2714" : "&7IsMeat: &c&l\u2718";
        finalDescription[finalDescription.length - --len] = "&7Nutrition: &e" + ((Optional)this.nutrition.getValue()).get();
        finalDescription[finalDescription.length - --len] = "&7Saturation: &e" + ((Optional)this.saturation.getValue()).get();
        finalDescription[finalDescription.length - --len] = "&7Can Always Eat: &e" + this.canAlwaysEat.getValue();
        --len;
        if (!SCore.is1v21v2Plus()) {
            finalDescription[finalDescription.length - len] = "&7Eat Seconds: &e" + ((Optional)this.eatSeconds.getValue()).get();
        }
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v20v5Plus();
    }

    @Override
    public boolean isApplicable(FeatureForItemArgs args) {
        return true;
    }

    @Override
    public void applyOnItemMeta(FeatureForItemArgs args) {
        if (this.isAvailable() && this.getIsMeat().getValue().booleanValue()) {
            ItemMeta meta = args.getMeta();
            FoodComponent food = meta.getFood();
            int nutrition = (Integer)((Optional)this.getNutrition().getValue()).get();
            if (nutrition < 0) {
                nutrition = 0;
            }
            food.setNutrition(nutrition);
            int saturation = (Integer)((Optional)this.getSaturation().getValue()).get();
            if (saturation < 0) {
                saturation = 0;
            }
            food.setSaturation((float)saturation);
            food.setCanAlwaysEat(this.getCanAlwaysEat().getValue().booleanValue());
            if (!SCore.is1v21v2Plus()) {
                int eatSeconds = (Integer)((Optional)this.getEatSeconds().getValue()).get();
                if (eatSeconds <= 0) {
                    eatSeconds = 1;
                }
                Class clazz = food.getClass();
                try {
                    Method method = clazz.getMethod("setEatSeconds", Integer.TYPE);
                    method.invoke((Object)food, eatSeconds);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            meta.setFood(food);
        }
    }

    @Override
    public void loadFromItemMeta(FeatureForItemArgs args) {
        ItemMeta meta;
        if (this.isAvailable() && (meta = args.getMeta()).hasFood()) {
            FoodComponent food = meta.getFood();
            this.getNutrition().setValue(Optional.of(food.getNutrition()));
            this.getSaturation().setValue(Optional.of(new Float(food.getSaturation()).intValue()));
            this.getCanAlwaysEat().setValue(food.canAlwaysEat());
            if (!SCore.is1v21v2Plus()) {
                Class clazz = food.getClass();
                try {
                    Method method = clazz.getMethod("getEatSeconds", new Class[0]);
                    int eatSeconds = (Integer)method.invoke((Object)food, new Object[0]);
                    this.getEatSeconds().setValue(Optional.of(eatSeconds));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            this.getIsMeat().setValue(true);
        }
    }

    @Override
    public void applyOnItem(@NotNull FeatureForItemArgs args) {
        new FoodFeaturesPaper().applyOnItem(args, this.isMeat.getValue());
    }

    @Override
    public void loadFromItem(@NotNull FeatureForItemArgs args) {
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.FOOD;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public FoodFeatures clone(FeatureParentInterface newParent) {
        FoodFeatures dropFeatures = new FoodFeatures(newParent);
        dropFeatures.nutrition = this.nutrition.clone(dropFeatures);
        dropFeatures.saturation = this.saturation.clone(dropFeatures);
        dropFeatures.isMeat = this.isMeat.clone(dropFeatures);
        dropFeatures.canAlwaysEat = this.canAlwaysEat.clone(dropFeatures);
        dropFeatures.eatSeconds = this.eatSeconds.clone(dropFeatures);
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.isMeat);
        features.add(this.nutrition);
        features.add(this.saturation);
        features.add(this.canAlwaysEat);
        if (!SCore.is1v21v2Plus()) {
            features.add(this.eatSeconds);
        }
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof FoodFeatures)) continue;
            FoodFeatures hiders = (FoodFeatures)feature;
            hiders.setNutrition(this.nutrition);
            hiders.setSaturation(this.saturation);
            hiders.setIsMeat(this.isMeat);
            hiders.setCanAlwaysEat(this.canAlwaysEat);
            hiders.setEatSeconds(this.eatSeconds);
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public IntegerFeature getNutrition() {
        return this.nutrition;
    }

    @Generated
    public IntegerFeature getSaturation() {
        return this.saturation;
    }

    @Generated
    public BooleanFeature getIsMeat() {
        return this.isMeat;
    }

    @Generated
    public BooleanFeature getCanAlwaysEat() {
        return this.canAlwaysEat;
    }

    @Generated
    public IntegerFeature getEatSeconds() {
        return this.eatSeconds;
    }

    @Generated
    public void setNutrition(IntegerFeature nutrition) {
        this.nutrition = nutrition;
    }

    @Generated
    public void setSaturation(IntegerFeature saturation) {
        this.saturation = saturation;
    }

    @Generated
    public void setIsMeat(BooleanFeature isMeat) {
        this.isMeat = isMeat;
    }

    @Generated
    public void setCanAlwaysEat(BooleanFeature canAlwaysEat) {
        this.canAlwaysEat = canAlwaysEat;
    }

    @Generated
    public void setEatSeconds(IntegerFeature eatSeconds) {
        this.eatSeconds = eatSeconds;
    }
}

