/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.itemcheckers;

import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public enum ItemCheckerEnum {
    AMOUNT(FeatureSettingsSCore.checkAmount),
    DISPLAY_NAME(FeatureSettingsSCore.checkDisplayName),
    MATERIAL(FeatureSettingsSCore.checkMaterial),
    CUSTOM_MODEL_DATA(FeatureSettingsSCore.checkCustomModelData),
    LORE(FeatureSettingsSCore.checkLore),
    DURABILITY(FeatureSettingsSCore.checkDurability),
    EXECUTABLEITEM_ID(FeatureSettingsSCore.checkExecutableItemID),
    EXECUTABLEITEM_USAGE(FeatureSettingsSCore.checkExecutableItemUsage),
    EXECUTABLEITEM_VARIABLES(FeatureSettingsSCore.checkExecutableItemVariables);

    public final FeatureSettingsInterface featureSetting;
    public boolean deprecated = false;

    private ItemCheckerEnum(FeatureSettingsInterface featureSetting) {
        this.featureSetting = featureSetting;
    }

    private ItemCheckerEnum(FeatureSettingsInterface featureSetting, boolean deprecated) {
        this.featureSetting = featureSetting;
        this.deprecated = deprecated;
    }

    public boolean check(ItemStack item1, ItemStack item2) {
        boolean item1HasMeta = item1.hasItemMeta();
        boolean item2HasMeta = item2.hasItemMeta();
        boolean oneOfThemNaNoMeta = !item1HasMeta || !item2HasMeta;
        boolean bothNaNoMeta = !item1HasMeta && !item2HasMeta;
        ItemMeta item1Meta = item1HasMeta ? item1.getItemMeta() : null;
        ItemMeta item2Meta = item2HasMeta ? item2.getItemMeta() : null;
        switch (this.ordinal()) {
            case 0: {
                return item1.getAmount() == item2.getAmount();
            }
            case 1: {
                boolean bothNaNoDisplayName;
                if (oneOfThemNaNoMeta) {
                    return bothNaNoMeta;
                }
                boolean item1HasDisplayName = item1Meta.hasDisplayName();
                boolean item2HasDisplayName = item2Meta.hasDisplayName();
                boolean oneOfThemNaNoDisplayName = !item1HasDisplayName || !item2HasDisplayName;
                boolean bl = bothNaNoDisplayName = !item1HasDisplayName && !item2HasDisplayName;
                if (oneOfThemNaNoDisplayName) {
                    return bothNaNoDisplayName;
                }
                return item1Meta.getDisplayName().equals(item2Meta.getDisplayName());
            }
            case 2: {
                return item1.getType() == item2.getType();
            }
            case 3: {
                boolean bothNaNoCustomModelData;
                if (oneOfThemNaNoMeta) {
                    return bothNaNoMeta;
                }
                boolean item1HasCustomModelData = item1Meta.hasCustomModelData();
                boolean item2HasCustomModelData = item2Meta.hasCustomModelData();
                boolean oneOfThemNaNoCustomModelData = !item1HasCustomModelData || !item2HasCustomModelData;
                boolean bl = bothNaNoCustomModelData = !item1HasCustomModelData && !item2HasCustomModelData;
                if (oneOfThemNaNoCustomModelData) {
                    return bothNaNoCustomModelData;
                }
                return item1Meta.getCustomModelData() == item2Meta.getCustomModelData();
            }
            case 4: {
                boolean bothNaNoLore;
                if (oneOfThemNaNoMeta) {
                    return bothNaNoMeta;
                }
                boolean item1HasLore = item1Meta.hasLore();
                boolean item2HasLore = item2Meta.hasLore();
                boolean oneOfThemNaNoLore = !item1HasLore || !item2HasLore;
                boolean bl = bothNaNoLore = !item1HasLore && !item2HasLore;
                if (oneOfThemNaNoLore) {
                    return bothNaNoLore;
                }
                return item1Meta.getLore().equals(item2Meta.getLore());
            }
            case 5: {
                return item1.getDurability() == item2.getDurability();
            }
            case 6: {
                if (oneOfThemNaNoMeta) {
                    return bothNaNoMeta;
                }
                return item1Meta.getPersistentDataContainer().getKeys().equals(item2Meta.getPersistentDataContainer().getKeys());
            }
            case 7: {
                if (oneOfThemNaNoMeta) {
                    return bothNaNoMeta;
                }
                return item1Meta.getPersistentDataContainer().getKeys().equals(item2Meta.getPersistentDataContainer().getKeys());
            }
            case 8: {
                if (oneOfThemNaNoMeta) {
                    return bothNaNoMeta;
                }
                return item1Meta.getPersistentDataContainer().getKeys().equals(item2Meta.getPersistentDataContainer().getKeys());
            }
        }
        return false;
    }

    @Generated
    public FeatureSettingsInterface getFeatureSetting() {
        return this.featureSetting;
    }
}

