/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.nbttags;

import com.ssomar.score.features.custom.nbttags.BooleanNBTTag;
import com.ssomar.score.features.custom.nbttags.ByteNBTTag;
import com.ssomar.score.features.custom.nbttags.DoubleNBTTag;
import com.ssomar.score.features.custom.nbttags.IntNBTTag;
import com.ssomar.score.features.custom.nbttags.NBTTag;
import com.ssomar.score.features.custom.nbttags.NBTTags;
import com.ssomar.score.features.custom.nbttags.StringNBTTag;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTType;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class CompoundNBTTag
extends NBTTag {
    List<NBTTag> nbtTags;

    public CompoundNBTTag(ConfigurationSection configurationSection) {
        super(configurationSection);
    }

    public CompoundNBTTag(String key, List<NBTTag> nbtTags) {
        super(key);
        this.nbtTags = nbtTags;
    }

    public CompoundNBTTag(String key, NBTCompound nbtCompound) {
        super(key);
        this.nbtTags = new ArrayList<NBTTag>();
        for (String s : nbtCompound.getKeys()) {
            if (NBTTags.blackListedTags().contains(s)) continue;
            NBTType type = nbtCompound.getType(s);
            switch (type) {
                case NBTTagInt: {
                    this.nbtTags.add(new IntNBTTag(s, nbtCompound.getInteger(s)));
                    break;
                }
                case NBTTagByte: {
                    this.nbtTags.add(new ByteNBTTag(s, nbtCompound.getByte(s)));
                    break;
                }
                case NBTTagByteArray: {
                    break;
                }
                case NBTTagCompound: {
                    this.nbtTags.add(new CompoundNBTTag(s, nbtCompound.getCompound(s)));
                    break;
                }
                case NBTTagDouble: {
                    this.nbtTags.add(new DoubleNBTTag(s, nbtCompound.getDouble(s)));
                    break;
                }
                case NBTTagEnd: {
                    break;
                }
                case NBTTagFloat: {
                    break;
                }
                case NBTTagIntArray: {
                    break;
                }
                case NBTTagList: {
                    break;
                }
                case NBTTagLong: {
                    break;
                }
                case NBTTagShort: {
                    break;
                }
                case NBTTagString: {
                    this.nbtTags.add(new StringNBTTag(s, nbtCompound.getString(s)));
                    break;
                }
            }
        }
    }

    @Override
    public boolean applyTo(ReadWriteNBT nbtItem, boolean onlyIfDifferent) {
        ReadWriteNBT compound = nbtItem.getOrCreateCompound(this.getKey());
        boolean different = false;
        for (NBTTag nbtTag : this.nbtTags) {
            different = nbtTag.applyTo(compound, onlyIfDifferent) || different;
        }
        return different;
    }

    @Override
    public boolean applyTo(NBTCompound nbtCompound, boolean onlyIfDifferent) {
        NBTCompound compound = nbtCompound.addCompound(this.getKey());
        boolean different = false;
        for (NBTTag nbtTag : this.nbtTags) {
            different = nbtTag.applyTo(compound, onlyIfDifferent) || different;
        }
        return different;
    }

    @Override
    public void saveValueInConfig(ConfigurationSection configurationSection, Integer index) {
        configurationSection.set("nbt." + index + ".type", (Object)"COMPOUND");
        if (this.nbtTags.isEmpty()) {
            configurationSection.set("nbt." + index + ".value", null);
        } else {
            ConfigurationSection newSection = configurationSection.createSection("nbt." + index + ".value");
            Integer subIndex = 0;
            for (NBTTag nbtTag : this.nbtTags) {
                nbtTag.saveInConfig(newSection, subIndex);
                Integer n = subIndex;
                subIndex = subIndex + 1;
            }
        }
    }

    @Override
    public void loadValueFromConfig(ConfigurationSection configurationSection) {
        this.nbtTags = new ArrayList<NBTTag>();
        ConfigurationSection subSection = configurationSection.getConfigurationSection("value");
        if (subSection != null && subSection.contains("nbt")) {
            ConfigurationSection nbtSection = subSection.getConfigurationSection("nbt");
            for (String nbtId : nbtSection.getKeys(false)) {
                ConfigurationSection tagSection = nbtSection.getConfigurationSection(nbtId);
                String type = tagSection.getString("type").toUpperCase();
                NBTTag tag = null;
                switch (type) {
                    case "BOOLEAN": 
                    case "BOOL": {
                        tag = new BooleanNBTTag(tagSection);
                        break;
                    }
                    case "STRING": 
                    case "STR": {
                        tag = new StringNBTTag(tagSection);
                        break;
                    }
                    case "DOUBLE": {
                        tag = new DoubleNBTTag(tagSection);
                        break;
                    }
                    case "INTEGER": 
                    case "INT": {
                        tag = new IntNBTTag(tagSection);
                        break;
                    }
                    case "BYTE": {
                        tag = new ByteNBTTag(tagSection);
                        break;
                    }
                    case "COMPOUND": {
                        tag = new CompoundNBTTag(tagSection);
                    }
                }
                if (tag == null) continue;
                this.nbtTags.add(tag);
            }
        }
    }

    @Generated
    public List<NBTTag> getNbtTags() {
        return this.nbtTags;
    }
}

