/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.nbttags;

import com.ssomar.score.features.custom.nbttags.NBTTag;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class IntNBTTag
extends NBTTag {
    private int valueInt;

    public IntNBTTag(ConfigurationSection configurationSection) {
        super(configurationSection);
    }

    public IntNBTTag(String key, int valueInt) {
        super(key);
        this.valueInt = valueInt;
    }

    @Override
    public boolean applyTo(ReadWriteNBT nbtItem, boolean onlyIfDifferent) {
        if (!onlyIfDifferent || nbtItem.getInteger(this.getKey()).intValue() != this.getValueInt()) {
            nbtItem.setInteger(this.getKey(), Integer.valueOf(this.getValueInt()));
            return true;
        }
        return false;
    }

    @Override
    public boolean applyTo(NBTCompound nbtCompound, boolean onlyIfDifferent) {
        if (!onlyIfDifferent || nbtCompound.getInteger(this.getKey()).intValue() != this.getValueInt()) {
            nbtCompound.setInteger(this.getKey(), Integer.valueOf(this.getValueInt()));
            return true;
        }
        return false;
    }

    @Override
    public void saveValueInConfig(ConfigurationSection configurationSection, Integer index) {
        configurationSection.set("nbt." + index + ".type", (Object)"INT");
        configurationSection.set("nbt." + index + ".value", (Object)this.getValueInt());
    }

    @Override
    public void loadValueFromConfig(ConfigurationSection configurationSection) {
        this.valueInt = configurationSection.getInt("value", 0);
    }

    public String toString() {
        return "INTEGER::" + this.getKey() + "::" + this.getValueInt();
    }

    @Generated
    public int getValueInt() {
        return this.valueInt;
    }
}

