/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.othereicooldowns.group;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.othereicooldowns.cooldown.OtherEICooldown;
import com.ssomar.score.features.custom.othereicooldowns.group.OtherEICooldownGroupFeatureEditor;
import com.ssomar.score.features.custom.othereicooldowns.group.OtherEICooldownGroupFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OtherEICooldownGroupFeature
extends FeatureWithHisOwnEditor<OtherEICooldownGroupFeature, OtherEICooldownGroupFeature, OtherEICooldownGroupFeatureEditor, OtherEICooldownGroupFeatureEditorManager>
implements FeaturesGroup<OtherEICooldown> {
    private Map<String, OtherEICooldown> attributes;

    public OtherEICooldownGroupFeature(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.otherEICooldowns);
        this.reset();
    }

    @Override
    public void reset() {
        this.attributes = new HashMap<String, OtherEICooldown>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String attributeID : enchantmentsSection.getKeys(false)) {
                OtherEICooldown attribute = new OtherEICooldown((FeatureParentInterface)this, attributeID);
                List<String> subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.attributes.put(attributeID, attribute);
            }
        }
        return error;
    }

    public void addOtherCooldowns(@NotNull Player player, @Nullable StringPlaceholder sp) {
        for (OtherEICooldown attribute : this.attributes.values()) {
            attribute.addOtherCooldowns(player, sp);
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection attributesSection = config.createSection(this.getName());
        for (String enchantmentID : this.attributes.keySet()) {
            this.attributes.get(enchantmentID).save(attributesSection);
        }
        if (this.isSavingOnlyIfDiffDefault() && attributesSection.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public OtherEICooldownGroupFeature getValue() {
        return this;
    }

    @Override
    public OtherEICooldownGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oOther CD(s) added: &e" + this.attributes.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public OtherEICooldown getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (OtherEICooldown x : this.attributes.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public OtherEICooldownGroupFeature clone(FeatureParentInterface newParent) {
        OtherEICooldownGroupFeature eF = new OtherEICooldownGroupFeature(newParent);
        eF.setAttributes(new HashMap<String, OtherEICooldown>(this.getAttributes()));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.attributes.values());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof OtherEICooldownGroupFeature)) continue;
            OtherEICooldownGroupFeature eF = (OtherEICooldownGroupFeature)feature;
            eF.setAttributes(this.getAttributes());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        OtherEICooldownGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "cd";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.attributes.containsKey(id)) continue;
            OtherEICooldown eF = new OtherEICooldown((FeatureParentInterface)this, id);
            this.attributes.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, OtherEICooldown feature) {
        this.attributes.remove(feature.getId());
    }

    @Generated
    public Map<String, OtherEICooldown> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, OtherEICooldown> attributes) {
        this.attributes = attributes;
    }
}

