/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.particles.group;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.particles.group.ParticlesGroupFeatureEditor;
import com.ssomar.score.features.custom.particles.group.ParticlesGroupFeatureEditorManager;
import com.ssomar.score.features.custom.particles.group.ParticlesPaper1194_120;
import com.ssomar.score.features.custom.particles.group.ParticlesSpigot1194_120;
import com.ssomar.score.features.custom.particles.group.ParticlesXenonDev112_1193;
import com.ssomar.score.features.custom.particles.particle.ParticleFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.projectiles.features.SProjectileFeatureInterface;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ParticlesGroupFeature
extends FeatureWithHisOwnEditor<ParticlesGroupFeature, ParticlesGroupFeature, ParticlesGroupFeatureEditor, ParticlesGroupFeatureEditorManager>
implements FeaturesGroup<ParticleFeature>,
SProjectileFeatureInterface {
    private Map<String, ParticleFeature> particles;
    private boolean notSaveIfNoValue;

    public ParticlesGroupFeature(FeatureParentInterface parent, boolean notSaveIfNoValue) {
        super(parent, FeatureSettingsSCore.particles);
        this.notSaveIfNoValue = notSaveIfNoValue;
        this.reset();
    }

    @Override
    public void reset() {
        this.particles = new HashMap<String, ParticleFeature>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String enchantmentID : enchantmentsSection.getKeys(false)) {
                ParticleFeature enchantment = new ParticleFeature((FeatureParentInterface)this, enchantmentID);
                List<String> subErrors = enchantment.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.particles.put(enchantmentID, enchantment);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfNoValue && this.particles.size() == 0) {
            return;
        }
        ConfigurationSection enchantmentsSection = config.createSection(this.getName());
        for (String enchantmentID : this.particles.keySet()) {
            this.particles.get(enchantmentID).save(enchantmentsSection);
        }
    }

    @Override
    public ParticlesGroupFeature getValue() {
        return this;
    }

    @Override
    public ParticlesGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oParticle(s) added: &e" + this.particles.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ParticleFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (ParticleFeature x : this.particles.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public ParticlesGroupFeature clone(FeatureParentInterface newParent) {
        ParticlesGroupFeature eF = new ParticlesGroupFeature(newParent, this.isNotSaveIfNoValue());
        HashMap<String, ParticleFeature> newEnchantments = new HashMap<String, ParticleFeature>();
        for (String x : this.particles.keySet()) {
            newEnchantments.put(x, this.particles.get(x).clone(eF));
        }
        eF.setParticles(newEnchantments);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.particles.values());
    }

    @Override
    public String getParentInfo() {
        if (this.getParent() == this) {
            return "";
        }
        return this.getParent().getParentInfo() + ".(" + this.getName() + ")";
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof ParticlesGroupFeature)) continue;
            ParticlesGroupFeature eF = (ParticlesGroupFeature)feature;
            eF.setParticles(this.getParticles());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        ParticlesGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "particle";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.particles.containsKey(id)) continue;
            ParticleFeature eF = new ParticleFeature((FeatureParentInterface)this, id);
            this.particles.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, ParticleFeature feature) {
        this.particles.remove(feature.getId());
    }

    @Override
    public void transformTheProjectile(Entity e, Player launcher, Material materialLaunched) {
        if (SCore.is1v19v4Plus()) {
            if (SCore.isSpigot()) {
                ParticlesSpigot1194_120.transformTheProjectile(this.particles, e, launcher, materialLaunched);
            } else {
                ParticlesPaper1194_120.transformTheProjectile(this.particles, e, launcher, materialLaunched);
            }
        } else {
            ParticlesXenonDev112_1193.transformTheProjectile(this.particles, e, launcher, materialLaunched);
        }
    }

    @Generated
    public Map<String, ParticleFeature> getParticles() {
        return this.particles;
    }

    @Generated
    public boolean isNotSaveIfNoValue() {
        return this.notSaveIfNoValue;
    }

    @Generated
    public void setParticles(Map<String, ParticleFeature> particles) {
        this.particles = particles;
    }

    @Generated
    public void setNotSaveIfNoValue(boolean notSaveIfNoValue) {
        this.notSaveIfNoValue = notSaveIfNoValue;
    }
}

