/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.sit;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SitFeatures
extends FeatureWithHisOwnEditor<SitFeatures, SitFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private BooleanFeature playerCanSit;

    public SitFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.sitFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.playerCanSit = new BooleanFeature(this, false, FeatureSettingsSCore.playerCanSit);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            error.addAll(this.playerCanSit.load(plugin, config.getConfigurationSection(this.getName()), isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.playerCanSit.save(section);
    }

    @Override
    public SitFeatures getValue() {
        return this;
    }

    @Override
    public SitFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = this.isRequirePremium() && !this.isPremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = this.playerCanSit.getValue() != false ? "&7Player can sit: &a&l\u2714" : "&7Player can sit: &c&l\u2718";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public SitFeatures clone(FeatureParentInterface newParent) {
        SitFeatures dropFeatures = new SitFeatures(newParent);
        dropFeatures.setPlayerCanSit(this.playerCanSit.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.playerCanSit);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof SitFeatures)) continue;
            SitFeatures dropFeatures = (SitFeatures)feature;
            dropFeatures.setPlayerCanSit(this.playerCanSit);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    public String getSimpleLocString(Location loc) {
        return loc.getWorld().getName() + "-" + loc.getBlockX() + "-" + loc.getBlockY() + "-" + loc.getBlockZ();
    }

    @Generated
    public BooleanFeature getPlayerCanSit() {
        return this.playerCanSit;
    }

    @Generated
    public void setPlayerCanSit(BooleanFeature playerCanSit) {
        this.playerCanSit = playerCanSit;
    }
}

