/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.usage.useperday;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.usage.useperday.manager.UsagePerDayManager;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsePerDayFeature
extends FeatureWithHisOwnEditor<UsePerDayFeature, UsePerDayFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private IntegerFeature maxUsePerDay;
    private ColoredStringFeature messageIfMaxReached;
    private BooleanFeature cancelEventIfMaxReached;
    private String id;

    public UsePerDayFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.usePerDay);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.maxUsePerDay = new IntegerFeature(this, Optional.ofNullable(-1), FeatureSettingsSCore.maxUsePerDay);
        this.messageIfMaxReached = new ColoredStringFeature(this, Optional.ofNullable("&4&l[ERROR] &c&oYou have reached the max use per day"), FeatureSettingsSCore.messageIfMaxReached);
        this.cancelEventIfMaxReached = new BooleanFeature(this, false, FeatureSettingsSCore.cancelEventIfMaxReached);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            errors.addAll(this.maxUsePerDay.load(plugin, section, isPremiumLoading));
            if ((Integer)((Optional)this.maxUsePerDay.getValue()).get() < -1) {
                this.maxUsePerDay.setValue(Optional.ofNullable(-1));
            }
            errors.addAll(this.messageIfMaxReached.load(plugin, section, isPremiumLoading));
            errors.addAll(this.cancelEventIfMaxReached.load(plugin, section, isPremiumLoading));
        }
        return errors;
    }

    public boolean verify(@NotNull Player player, @Nullable Event event, @Nullable StringPlaceholder sp) {
        if (!((Optional)this.maxUsePerDay.getValue()).isPresent() || (Integer)((Optional)this.maxUsePerDay.getValue()).get() == -1) {
            return true;
        }
        int count = UsagePerDayManager.getInstance().getCount(player.getName(), this.getId());
        int max = (Integer)((Optional)this.maxUsePerDay.getValue()).get();
        SsomarDev.testMsg("count: " + count + " >> max " + max, true);
        if (count >= (Integer)((Optional)this.maxUsePerDay.getValue()).get()) {
            this.sendMessageIfMaxReached(player, sp);
            if (event != null && event instanceof Cancellable && this.cancelEventIfMaxReached.getValue().booleanValue()) {
                ((Cancellable)event).setCancelled(true);
            }
            return false;
        }
        return true;
    }

    public void incrementUsage(@NotNull Player player) {
        if ((Integer)((Optional)this.maxUsePerDay.getValue()).get() != -1) {
            UsagePerDayManager.getInstance().insertUsage(player.getName(), this.getId());
        }
    }

    public void sendMessageIfMaxReached(@NotNull Player player, @Nullable StringPlaceholder sp) {
        String message = (String)((Optional)this.messageIfMaxReached.getValue()).get();
        if (StringConverter.decoloredString(message).isEmpty()) {
            return;
        }
        if (sp != null) {
            message = sp.replacePlaceholder(message);
        }
        player.sendMessage(StringConverter.coloredString(message));
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if ((Integer)((Optional)this.maxUsePerDay.getValue()).get() != -1) {
            ConfigurationSection section = config.createSection(this.getName());
            this.maxUsePerDay.save(section);
            this.messageIfMaxReached.save(section);
            this.cancelEventIfMaxReached.save(section);
        }
    }

    @Override
    public UsePerDayFeature getValue() {
        return this;
    }

    @Override
    public UsePerDayFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = !this.isPremium() && this.isRequirePremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = (Integer)((Optional)this.maxUsePerDay.getValue()).get() != -1 ? "&7Max Use per Day: &e" + ((Optional)this.maxUsePerDay.getValue()).get() : "&7Max Use per Day: &c&l\u2718";
        finalDescription[finalDescription.length - 2] = "&7Message if Max: &e" + (String)((Optional)this.messageIfMaxReached.getValue()).get();
        finalDescription[finalDescription.length - 1] = this.cancelEventIfMaxReached.getValue() != false ? "&7Cancel event if Max: &a&l\u2714" : "&7Cancel event if Max: &c&l\u2718";
        for (int i = 0; i < finalDescription.length; ++i) {
            String command = finalDescription[i];
            if (command.length() > 40) {
                command = command.substring(0, 39) + "...";
            }
            finalDescription[i] = command;
        }
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public UsePerDayFeature clone(FeatureParentInterface newParent) {
        UsePerDayFeature dropFeatures = new UsePerDayFeature(newParent, this.id);
        dropFeatures.setMaxUsePerDay(this.maxUsePerDay.clone(dropFeatures));
        dropFeatures.setMessageIfMaxReached(this.messageIfMaxReached.clone(dropFeatures));
        dropFeatures.setCancelEventIfMaxReached(this.cancelEventIfMaxReached.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.maxUsePerDay, this.messageIfMaxReached, this.cancelEventIfMaxReached));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof UsePerDayFeature)) continue;
            UsePerDayFeature hiders = (UsePerDayFeature)feature;
            if ((Integer)((Optional)this.maxUsePerDay.getValue()).get() < -1) {
                this.maxUsePerDay.setValue(Optional.ofNullable(-1));
            }
            hiders.setMaxUsePerDay(this.maxUsePerDay);
            hiders.setMessageIfMaxReached(this.messageIfMaxReached);
            hiders.setCancelEventIfMaxReached(this.cancelEventIfMaxReached);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        if (this.isRequirePremium() && !this.isPremium()) {
            return;
        }
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public IntegerFeature getMaxUsePerDay() {
        return this.maxUsePerDay;
    }

    @Generated
    public ColoredStringFeature getMessageIfMaxReached() {
        return this.messageIfMaxReached;
    }

    @Generated
    public BooleanFeature getCancelEventIfMaxReached() {
        return this.cancelEventIfMaxReached;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setMaxUsePerDay(IntegerFeature maxUsePerDay) {
        this.maxUsePerDay = maxUsePerDay;
    }

    @Generated
    public void setMessageIfMaxReached(ColoredStringFeature messageIfMaxReached) {
        this.messageIfMaxReached = messageIfMaxReached;
    }

    @Generated
    public void setCancelEventIfMaxReached(BooleanFeature cancelEventIfMaxReached) {
        this.cancelEventIfMaxReached = cancelEventIfMaxReached;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

