/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.weaponFeatures;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureForItemNewPaperComponents;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.strings.StringConverter;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Weapon;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WeaponFeatures
extends FeatureWithHisOwnEditor<WeaponFeatures, WeaponFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItemNewPaperComponents {
    private BooleanFeature enable;
    private IntegerFeature disableBlockingTime;
    private IntegerFeature damagePerAttack;

    public WeaponFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.weaponFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.enable = new BooleanFeature(this, false, FeatureSettingsSCore.enable);
        this.disableBlockingTime = new IntegerFeature(this, Optional.of(0), FeatureSettingsSCore.disableBlockingTime);
        this.damagePerAttack = new IntegerFeature(this, Optional.of(5), FeatureSettingsSCore.damagePerAttack);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            errors.addAll(this.enable.load(plugin, section, isPremiumLoading));
            errors.addAll(this.disableBlockingTime.load(plugin, section, isPremiumLoading));
            errors.addAll(this.damagePerAttack.load(plugin, section, isPremiumLoading));
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.enable.save(section);
        this.disableBlockingTime.save(section);
        this.damagePerAttack.save(section);
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public WeaponFeatures getValue() {
        return this;
    }

    @Override
    public WeaponFeatures initItemParentEditor(GUI gui, int slot) {
        int len = 4;
        String[] finalDescription = new String[this.getEditorDescription().length + len];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - len] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - --len] = this.enable.getValue() != false ? "&7Enabled: &a&l\u2714" : "&7Disabled: &c&l\u2718";
        finalDescription[finalDescription.length - --len] = "&7Disable Blocking Time: &e" + ((Optional)this.disableBlockingTime.getValue()).get();
        finalDescription[finalDescription.length - --len] = "&7Damage Per Attack: &e" + ((Optional)this.damagePerAttack.getValue()).get();
        --len;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public boolean isAvailable() {
        return SCore.isPaperOrFork() && SCore.is1v21v5Plus();
    }

    @Override
    public boolean isApplicable(FeatureForItemArgs args) {
        return true;
    }

    @Override
    public void applyOnItemMeta(FeatureForItemArgs args) {
    }

    @Override
    public void loadFromItemMeta(FeatureForItemArgs args) {
    }

    @Override
    public void applyOnItem(@NotNull FeatureForItemArgs args) {
        if (this.isAvailable() && this.enable.getValue().booleanValue()) {
            ItemStack item = args.getItem();
            SsomarDev.testMsg("Weapon features applyOnItem2", true);
            try {
                item.setData(DataComponentTypes.WEAPON, (DataComponentBuilder)Weapon.weapon().disableBlockingForSeconds((float)((Integer)((Optional)this.disableBlockingTime.getValue()).get()).intValue()).itemDamagePerAttack(((Integer)((Optional)this.damagePerAttack.getValue()).get()).intValue()));
            }
            catch (Exception e) {
                Utils.sendConsoleMsg(SCore.plugin, "&cError while applying the weapon features on an item");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void loadFromItem(@NotNull FeatureForItemArgs args) {
        ItemStack item;
        if (this.isAvailable() && (item = args.getItem()).hasData((DataComponentType)DataComponentTypes.WEAPON)) {
            Weapon weapon = (Weapon)item.getData(DataComponentTypes.WEAPON);
            this.enable.setValue(true);
            this.disableBlockingTime.setValue(Optional.of((int)weapon.disableBlockingForSeconds()));
            this.damagePerAttack.setValue(Optional.of(weapon.itemDamagePerAttack()));
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.WEAPON;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public WeaponFeatures clone(FeatureParentInterface newParent) {
        WeaponFeatures dropFeatures = new WeaponFeatures(newParent);
        dropFeatures.setEnable(this.enable.clone(dropFeatures));
        dropFeatures.setDisableBlockingTime(this.disableBlockingTime.clone(dropFeatures));
        dropFeatures.setDamagePerAttack(this.damagePerAttack.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.enable);
        features.add(this.disableBlockingTime);
        features.add(this.damagePerAttack);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof WeaponFeatures)) continue;
            WeaponFeatures hiders = (WeaponFeatures)feature;
            hiders.setEnable(this.enable);
            hiders.setDisableBlockingTime(this.disableBlockingTime);
            hiders.setDamagePerAttack(this.damagePerAttack);
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public BooleanFeature getEnable() {
        return this.enable;
    }

    @Generated
    public IntegerFeature getDisableBlockingTime() {
        return this.disableBlockingTime;
    }

    @Generated
    public IntegerFeature getDamagePerAttack() {
        return this.damagePerAttack;
    }

    @Generated
    public void setEnable(BooleanFeature enable) {
        this.enable = enable;
    }

    @Generated
    public void setDisableBlockingTime(IntegerFeature disableBlockingTime) {
        this.disableBlockingTime = disableBlockingTime;
    }

    @Generated
    public void setDamagePerAttack(IntegerFeature damagePerAttack) {
        this.damagePerAttack = damagePerAttack;
    }
}

