/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.DetailedClick;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DetailedClickFeature
extends FeatureAbstract<Optional<DetailedClick>, DetailedClickFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<DetailedClick> value;
    private Optional<DetailedClick> defaultValue;

    public DetailedClickFeature(FeatureParentInterface parent, Optional<DetailedClick> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        try {
            DetailedClick material = DetailedClick.valueOf(colorStr);
            this.value = Optional.ofNullable(material);
            FeatureReturnCheckPremium<DetailedClick> checkPremium = this.checkPremium("DetailedClick", material, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            errors.add("&cERROR, Couldn't load the DetailedClick value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> DetailedClick available: RIGHT, LEFT, RIGHT_OR_LEFT");
            this.value = Optional.empty();
        }
        return errors;
    }

    public boolean verifClick(DetailedClick dC) {
        if (dC != null && this.value.isPresent()) {
            switch (this.value.get()) {
                case RIGHT_OR_LEFT: {
                    return true;
                }
                case LEFT: {
                    return dC.equals((Object)DetailedClick.LEFT);
                }
                case RIGHT: {
                    return dC.equals((Object)DetailedClick.RIGHT);
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(detailedClick -> config.set(this.getName(), (Object)detailedClick.name()));
    }

    @Override
    public Optional<DetailedClick> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public DetailedClickFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&8>> &6UP: &eRIGHT | &6DOWN: &eLEFT";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        DetailedClick finalValue = ((Optional)value).orElse(DetailedClick.RIGHT);
        this.updateDetailedClick(finalValue, gui);
    }

    @Override
    public DetailedClickFeature clone(FeatureParentInterface newParent) {
        DetailedClickFeature clone = new DetailedClickFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateDetailedClick(this.nextDetailedClick(this.getDetailedClick((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateDetailedClick(this.prevDetailedClick(this.getDetailedClick((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public DetailedClick nextDetailedClick(DetailedClick material) {
        boolean next = false;
        for (DetailedClick check : this.getSortDetailedClicks()) {
            if (check.equals((Object)material)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortDetailedClicks().get(0);
    }

    public DetailedClick prevDetailedClick(DetailedClick material) {
        int i = -1;
        int cpt = 0;
        for (DetailedClick check : this.getSortDetailedClicks()) {
            if (check.equals((Object)material)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortDetailedClicks().get(this.getSortDetailedClicks().size() - 1);
        }
        return this.getSortDetailedClicks().get(cpt - 1);
    }

    public void updateDetailedClick(DetailedClick typeTarget, GUI gui) {
        this.value = Optional.of(typeTarget);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortDetailedClicks().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (DetailedClick check : this.getSortDetailedClicks()) {
            if (typeTarget.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + typeTarget.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (DetailedClick check : this.getSortDetailedClicks()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public DetailedClick getDetailedClick(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return DetailedClick.valueOf(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<DetailedClick> getSortDetailedClicks() {
        TreeMap<String, DetailedClick> map = new TreeMap<String, DetailedClick>();
        for (DetailedClick l : DetailedClick.values()) {
            map.put(l.name(), l);
        }
        return new ArrayList<DetailedClick>(map.values());
    }

    @Generated
    public Optional<DetailedClick> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<DetailedClick> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<DetailedClick> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

