/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.SCore;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.custom.enchantments.enchantment.EnchantmentWithLevelFeature;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantmentFeature
extends FeatureAbstract<Optional<Enchantment>, EnchantmentFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<Enchantment> value;
    private Optional<Enchantment> defaultValue;

    public EnchantmentFeature(FeatureParentInterface parent, Optional<Enchantment> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        Optional<Enchantment> optional;
        ArrayList<String> errors = new ArrayList<String>();
        String enchantStr = config.getString(this.getName(), "NULL");
        if (!(enchantStr = this.transformOldFormat(enchantStr)).contains(">>")) {
            enchantStr = enchantStr.toUpperCase();
        }
        if (!(optional = this.getEnchantment(enchantStr)).isPresent()) {
            errors.add("&cERROR, Couldn't load the Enchantment value of " + this.getName() + " from config, value: " + enchantStr + " &7&o" + this.getParent().getParentInfo() + " &6>> Enchantments available: Look in-game, it's the same name");
            this.value = Optional.empty();
        } else {
            this.value = optional;
            FeatureReturnCheckPremium<Enchantment> checkPremium = this.checkPremium("Enchantment", optional.get(), this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        return errors;
    }

    public String transformOldFormat(String str) {
        if (str.contains("SPACE_")) {
            str = str.replace("SPACE_", "SPACE>>");
        } else if (str.contains("TOKEN-ENCHANT_")) {
            str = str.replace("TOKEN-ENCHANT_", "TOKENENCHANT>>");
        } else if (str.contains("ENCHANTS-SQUARED_")) {
            str = str.replace("ENCHANTS-SQUARED_", "ENCHANTSSQUARED>>");
        } else if (str.contains("BETTER-ENCHANTMENTS_")) {
            str = str.replace("BETTER-ENCHANTMENTS_", "BETTERENCHANTMENTS>>");
        } else if (str.contains("FILTERED-HOPPERS_")) {
            str = str.replace("FILTERED-HOPPERS_", "FILTEREDHOPPERS>>");
        }
        return str;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object optional = this.getValue();
        if (((Optional)optional).isPresent()) {
            String enchantName = this.getEnchantmentName((Enchantment)((Optional)optional).get());
            config.set(this.getName(), (Object)enchantName);
        } else {
            config.set(this.getName(), null);
        }
    }

    @Override
    public Optional<Enchantment> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public EnchantmentFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object optional = this.getValue();
        if (((Optional)optional).isPresent()) {
            this.updateEnchantment((Enchantment)((Optional)optional).get(), gui);
        } else {
            this.updateEnchantment(EnchantmentWithLevelFeature.getDefaultEnchantment(), gui);
        }
    }

    @Override
    public EnchantmentFeature clone(FeatureParentInterface newParent) {
        EnchantmentFeature clone = new EnchantmentFeature(newParent, this.defaultValue, this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        Enchantment enchantment = this.getEnchantment((GUI)manager.getCache().get(editor));
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        enchantment = this.nextEnchantment(enchantment);
        this.updateEnchantment(enchantment, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        Enchantment enchantment = this.getEnchantment((GUI)manager.getCache().get(editor));
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        enchantment = this.prevEnchantment(enchantment);
        this.updateEnchantment(enchantment, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateEnchantment(this.nextEnchantment(this.getEnchantment((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateEnchantment(this.prevEnchantment(this.getEnchantment((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public Enchantment nextEnchantment(Enchantment enchantment) {
        boolean next = false;
        for (Enchantment check : this.getSortEnchantments()) {
            if (check.equals(enchantment)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortEnchantments().get(0);
    }

    public Enchantment prevEnchantment(Enchantment enchantment) {
        int i = -1;
        int cpt = 0;
        for (Enchantment check : this.getSortEnchantments()) {
            if (check.equals(enchantment)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortEnchantments().get(this.getSortEnchantments().size() - 1);
        }
        return this.getSortEnchantments().get(cpt - 1);
    }

    public void updateEnchantment(Enchantment enchantment, GUI gui) {
        this.value = Optional.of(enchantment);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        boolean find = false;
        for (Enchantment check : this.getSortEnchantments()) {
            if (enchantment.equals(check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + this.getEnchantmentName(enchantment)));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + this.getEnchantmentName(check)));
        }
        for (Enchantment check : this.getSortEnchantments()) {
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + this.getEnchantmentName(check)));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public Enchantment getEnchantment(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return this.getEnchantment(str.split("\u27a4 ")[1]).get();
        }
        return null;
    }

    public List<Enchantment> getSortEnchantments() {
        TreeMap<String, Enchantment> map = new TreeMap<String, Enchantment>();
        for (Enchantment l : Enchantment.values()) {
            map.put(this.getEnchantmentName(l), l);
        }
        return new ArrayList<Enchantment>(map.values());
    }

    public String getEnchantmentName(Enchantment enchantment) {
        String name = "";
        name = !SCore.is1v12Less() ? ((name = enchantment.getKey().toString()).contains("minecraft:") ? name.split("minecraft:")[1] : name.split(":")[0].toUpperCase() + ">>" + enchantment.getName()) : enchantment.getName();
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public Optional<Enchantment> getEnchantment(String enchantmentName) {
        Enchantment enchantment = null;
        try {
            if (enchantmentName.contains(">>")) {
                enchantmentName = enchantmentName.split(">>")[1];
                enchantment = Enchantment.getByName((String)enchantmentName);
            } else {
                enchantment = !SCore.is1v12Less() ? Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantmentName.toLowerCase())) : Enchantment.getByName((String)enchantmentName);
            }
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.ofNullable(enchantment);
    }

    @Generated
    public Optional<Enchantment> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<Enchantment> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<Enchantment> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

