/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.score.SCore;
import com.ssomar.score.api.executableitems.ExecutableItemsAPI;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObjectBuildable;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ExecutableItemFeature
extends FeatureAbstract<Optional<ExecutableItemInterface>, ExecutableItemFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<String> value = Optional.empty();
    private boolean returnErrorIfExecItemNotExists = false;
    private boolean disableDoubleClick = false;

    public ExecutableItemFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "");
        if (colorStr.isEmpty()) {
            this.value = Optional.empty();
            if (this.returnErrorIfExecItemNotExists) {
                errors.add("&cERROR, Couldn't load the ExecutableItemID, because it's empty &7&o" + this.getParent().getParentInfo());
            }
        } else {
            this.value = Optional.of(colorStr);
            if (this.returnErrorIfExecItemNotExists) {
                if (!Dependency.EXECUTABLE_ITEMS.isEnabled()) {
                    errors.add("&cERROR, Couldn't load the ExecutableItemID: " + this.value.get() + " because ExecutableItems is not enabled/installed &7&o" + this.getParent().getParentInfo());
                } else if (!ExecutableItemsAPI.getExecutableItemsManager().isValidID(this.value.get())) {
                    errors.add("&cERROR, Couldn't load the ExecutableItemID: " + this.value.get() + " because it doesn't exist or is not loaded correctly &7&o" + this.getParent().getParentInfo());
                }
            }
        }
        return errors;
    }

    public Optional<SObjectBuildable> getBuildable() {
        if (this.value.isPresent() && Dependency.EXECUTABLE_ITEMS.isEnabled() && ExecutableItemsAPI.getExecutableItemsManager().isValidID(this.value.get())) {
            return Optional.of((SObjectBuildable)ExecutableItemsAPI.getExecutableItemsManager().getExecutableItem(this.value.get()).get());
        }
        return Optional.empty();
    }

    @Override
    public void save(ConfigurationSection config) {
        this.value.ifPresent(s -> config.set(this.getName(), s));
    }

    @Override
    public Optional<ExecutableItemInterface> getValue() {
        if (this.value.isPresent() && SCore.hasExecutableItems && ExecutableItemsAPI.getExecutableItemsManager().isValidID(this.value.get())) {
            return ExecutableItemsAPI.getExecutableItemsManager().getExecutableItem(this.value.get());
        }
        return Optional.empty();
    }

    public Optional<String> getValueID() {
        return this.value;
    }

    @Override
    public ExecutableItemFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = "&8>> &6DOUBLE CLICK : &bOPEN EDITOR";
        finalDescription[finalDescription.length - 2] = "&8>> &6SHIFT : &eBOOST SCROLL";
        finalDescription[finalDescription.length - 1] = "&8>> &6UP: &eRIGHT | &6DOWN: &eLEFT";
        ItemStack item = new ItemStack(this.getEditorMaterial());
        if (this.value.isPresent() && SCore.hasExecutableItems && ExecutableItemsAPI.getExecutableItemsManager().isValidID(this.value.get())) {
            item = ExecutableItemsAPI.getExecutableItemsManager().getExecutableItem(this.value.get()).get().buildItem(1, Optional.empty(), Optional.empty());
        }
        gui.createItem(item, 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        if (SCore.hasExecutableItems) {
            if (this.value.isPresent() && ExecutableItemsAPI.getExecutableItemsManager().isValidID(this.value.get())) {
                this.updateExecutableItem(this.value.get(), gui);
            } else {
                this.updateExecutableItem(ExecutableItemsAPI.getExecutableItemsManager().getExecutableItemIdsList().get(0), gui);
            }
        } else {
            this.updateExecutableItem(null, gui);
        }
    }

    @Override
    public ExecutableItemFeature clone(FeatureParentInterface newParent) {
        ExecutableItemFeature clone = new ExecutableItemFeature(newParent, this.getFeatureSettings());
        clone.value = this.value;
        clone.returnErrorIfExecItemNotExists = this.returnErrorIfExecItemNotExists;
        clone.disableDoubleClick = this.disableDoubleClick;
        return clone;
    }

    @Override
    public void reset() {
        this.value = Optional.empty();
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        if (SCore.hasExecutableItems) {
            String id = this.getExecutableItem((GUI)manager.getCache().get(editor)).get();
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            id = this.nextExecutableItem(id);
            this.updateExecutableItem(id, (GUI)manager.getCache().get(editor));
        }
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        if (SCore.hasExecutableItems) {
            String id = this.getExecutableItem((GUI)manager.getCache().get(editor)).get();
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            id = this.prevExecutableItem(id);
            this.updateExecutableItem(id, (GUI)manager.getCache().get(editor));
        }
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        if (SCore.hasExecutableItems) {
            this.updateExecutableItem(this.nextExecutableItem(this.getExecutableItem((GUI)manager.getCache().get(editor)).get()), (GUI)manager.getCache().get(editor));
        }
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        if (SCore.hasExecutableItems) {
            this.updateExecutableItem(this.prevExecutableItem(this.getExecutableItem((GUI)manager.getCache().get(editor)).get()), (GUI)manager.getCache().get(editor));
        }
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        Object id;
        if (this.disableDoubleClick) {
            return false;
        }
        this.rightClicked(editor, manager);
        this.rightClicked(editor, manager);
        if (SCore.hasExecutableItems && ((Optional)(id = this.getValue())).isPresent()) {
            ExecutableItem exe = (ExecutableItem)((Optional)id).get();
            exe.openEditor(editor);
        }
        return true;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public String nextExecutableItem(String id) {
        boolean next = false;
        for (String check : this.getSortExecutableItems()) {
            if (check.equals(id)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortExecutableItems().get(0);
    }

    public String prevExecutableItem(String id) {
        int i = -1;
        int cpt = 0;
        for (String check : this.getSortExecutableItems()) {
            if (check.equals(id)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortExecutableItems().get(this.getSortExecutableItems().size() - 1);
        }
        return this.getSortExecutableItems().get(cpt - 1);
    }

    public void updateExecutableItem(String id, GUI gui) {
        if (id == null) {
            id = "NULLLLL";
        }
        this.value = Optional.of(id);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        int slot = gui.getInv().first(item);
        this.initItemParentEditor(gui, slot);
        item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 4);
        int maxSize = lore.size();
        if ((maxSize += this.getSortExecutableItems().size()) > 17) {
            maxSize = 17;
        }
        if (SCore.hasExecutableItems) {
            boolean find = false;
            for (String check : this.getSortExecutableItems()) {
                if (id.equals(check)) {
                    lore.add(StringConverter.coloredString("&2\u27a4 &a" + id));
                    find = true;
                    continue;
                }
                if (!find) continue;
                if (lore.size() == maxSize) break;
                lore.add(StringConverter.coloredString("&6\u2726 &e" + check));
            }
            for (String check : this.getSortExecutableItems()) {
                if (lore.size() != maxSize) {
                    lore.add(StringConverter.coloredString("&6\u2726 &e" + check));
                    continue;
                }
                break;
            }
        } else {
            lore.add(StringConverter.coloredString("&4\u27a4 &cYou must have &6ExecutableItems"));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item);
    }

    public Optional<String> getExecutableItem(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            if (str.contains("You must have &6ExecutableItems")) {
                return Optional.empty();
            }
            str = StringConverter.decoloredString(str);
            return Optional.ofNullable(str.split("\u27a4 ")[1]);
        }
        return Optional.empty();
    }

    public List<String> getSortExecutableItems() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (SCore.hasExecutableItems) {
            for (String id : ExecutableItemsAPI.getExecutableItemsManager().getExecutableItemIdsList()) {
                map.put(id, id);
            }
        }
        return new ArrayList<String>(map.values());
    }

    @Generated
    public boolean isReturnErrorIfExecItemNotExists() {
        return this.returnErrorIfExecItemNotExists;
    }

    @Generated
    public boolean isDisableDoubleClick() {
        return this.disableDoubleClick;
    }

    @Generated
    public void setValue(Optional<String> value) {
        this.value = value;
    }

    @Generated
    public void setReturnErrorIfExecItemNotExists(boolean returnErrorIfExecItemNotExists) {
        this.returnErrorIfExecItemNotExists = returnErrorIfExecItemNotExists;
    }

    @Generated
    public void setDisableDoubleClick(boolean disableDoubleClick) {
        this.disableDoubleClick = disableDoubleClick;
    }
}

