/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.projectiles.SProjectileType;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SProjectileTypeFeature
extends FeatureAbstract<Optional<SProjectileType>, SProjectileTypeFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<SProjectileType> value;
    private Optional<SProjectileType> defaultValue;

    public SProjectileTypeFeature(FeatureParentInterface parent, Optional<SProjectileType> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        if (colorStr.equals("NULL")) {
            this.value = this.defaultValue;
        } else {
            try {
                SProjectileType material = SProjectileType.valueOfCustom(colorStr);
                this.value = Optional.ofNullable(material);
                FeatureReturnCheckPremium<SProjectileType> checkPremium = this.checkPremium("Projectile type", material, this.defaultValue, isPremiumLoading);
                if (checkPremium.isHasError()) {
                    this.value = Optional.of(checkPremium.getNewValue());
                }
            }
            catch (Exception e) {
                errors.add("&cERROR, Couldn't load the Projectile type value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> Type target available: ONLY_BLOCK, ONLY_AIR, NO_TYPE_TARGET");
                this.value = Optional.empty();
            }
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(sProjectileType -> config.set(this.getName(), (Object)sProjectileType.name()));
    }

    @Override
    public Optional<SProjectileType> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public SProjectileTypeFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&8>> &6UP: &eRIGHT | &6DOWN: &eLEFT";
        gui.createItem(((SProjectileType)((Object)((Optional)this.getValue()).get())).getMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        SProjectileType finalValue = ((Optional)value).orElse(SProjectileType.ARROW);
        this.updateSprojectileType(finalValue, gui);
    }

    @Override
    public SProjectileTypeFeature clone(FeatureParentInterface newParent) {
        SProjectileTypeFeature clone = new SProjectileTypeFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateSprojectileType(this.nextSProjectileType(this.getSProjectileType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateSprojectileType(this.prevSProjectileType(this.getSProjectileType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public SProjectileType nextSProjectileType(SProjectileType material) {
        boolean next = false;
        for (SProjectileType check : this.getSortSProjectileTypes()) {
            if (check.equals((Object)material)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortSProjectileTypes().get(0);
    }

    public SProjectileType prevSProjectileType(SProjectileType material) {
        int i = -1;
        int cpt = 0;
        for (SProjectileType check : this.getSortSProjectileTypes()) {
            if (check.equals((Object)material)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortSProjectileTypes().get(this.getSortSProjectileTypes().size() - 1);
        }
        return this.getSortSProjectileTypes().get(cpt - 1);
    }

    public void updateSprojectileType(SProjectileType typeTarget, GUI gui) {
        this.value = Optional.of(typeTarget);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortSProjectileTypes().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (SProjectileType check : this.getSortSProjectileTypes()) {
            if (typeTarget.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + typeTarget.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (SProjectileType check : this.getSortSProjectileTypes()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public SProjectileType getSProjectileType(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return SProjectileType.valueOf(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<SProjectileType> getSortSProjectileTypes() {
        TreeMap<String, SProjectileType> map = new TreeMap<String, SProjectileType>();
        for (SProjectileType l : SProjectileType.values()) {
            map.put(l.name(), l);
        }
        return new ArrayList<SProjectileType>(map.values());
    }

    @Generated
    public Optional<SProjectileType> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<SProjectileType> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<SProjectileType> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

