/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.AttributeSlot;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SlotFeature
extends FeatureAbstract<Optional<AttributeSlot>, SlotFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<AttributeSlot> value;
    private Optional<AttributeSlot> defaultValue;
    private boolean onlyArmorSlots = false;

    public SlotFeature(FeatureParentInterface parent, Optional<AttributeSlot> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        if (colorStr.equals("NULL")) {
            this.value = this.defaultValue;
            return errors;
        }
        try {
            AttributeSlot attributeSlot = AttributeSlot.valueOf(colorStr.toUpperCase());
            this.value = Optional.ofNullable(attributeSlot);
            FeatureReturnCheckPremium<AttributeSlot> checkPremium = this.checkPremium("Slot", attributeSlot, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            errors.add("&cERROR, Couldn't load the Slot value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> HEAD, CHEST, FEET, LEGS, HAND, OFF_HAND, ALL_SLOTS");
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (((Optional)this.getValue()).isPresent()) {
            if (this.defaultValue.isPresent() && this.isSavingOnlyIfDiffDefault() && ((AttributeSlot)((Object)((Optional)this.getValue()).get())).equals((Object)this.defaultValue.get())) {
                config.set(this.getName(), null);
                return;
            }
            config.set(this.getName(), (Object)((AttributeSlot)((Object)((Optional)this.getValue()).get())).name());
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public Optional<AttributeSlot> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    public Optional<EquipmentSlot> getEquipmentSlotValue() {
        if (((Optional)this.getValue()).isPresent()) {
            try {
                return Optional.of(EquipmentSlot.valueOf((String)((AttributeSlot)((Object)((Optional)this.getValue()).get())).name().toUpperCase()));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public SlotFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        AttributeSlot finalValue = ((Optional)value).orElse(AttributeSlot.HAND);
        this.updateAttributeSlot(finalValue, gui);
    }

    @Override
    public SlotFeature clone(FeatureParentInterface newParent) {
        SlotFeature clone = new SlotFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.setOnlyArmorSlots(this.onlyArmorSlots);
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        AttributeSlot slot = this.getAttributeSlot((GUI)manager.getCache().get(editor));
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        slot = this.nextAttributeSlot(slot);
        this.updateAttributeSlot(slot, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        AttributeSlot slot = this.getAttributeSlot((GUI)manager.getCache().get(editor));
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        slot = this.prevAttributeSlot(slot);
        this.updateAttributeSlot(slot, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateAttributeSlot(this.nextAttributeSlot(this.getAttributeSlot((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateAttributeSlot(this.prevAttributeSlot(this.getAttributeSlot((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public AttributeSlot nextAttributeSlot(AttributeSlot slot) {
        boolean next = false;
        for (AttributeSlot check : this.getSortAttributeSlots()) {
            if (check.equals((Object)slot)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortAttributeSlots().get(0);
    }

    public AttributeSlot prevAttributeSlot(AttributeSlot slot) {
        int i = -1;
        int cpt = 0;
        for (AttributeSlot check : this.getSortAttributeSlots()) {
            if (check.equals((Object)slot)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortAttributeSlots().get(this.getSortAttributeSlots().size() - 1);
        }
        return this.getSortAttributeSlots().get(cpt - 1);
    }

    public void updateAttributeSlot(AttributeSlot slot, GUI gui) {
        this.value = Optional.of(slot);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortAttributeSlots().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (AttributeSlot check : this.getSortAttributeSlots()) {
            if (slot.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + slot.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (AttributeSlot check : this.getSortAttributeSlots()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public AttributeSlot getAttributeSlot(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return AttributeSlot.valueOf(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<AttributeSlot> getSortAttributeSlots() {
        TreeMap<String, AttributeSlot> map = new TreeMap<String, AttributeSlot>();
        for (AttributeSlot l : AttributeSlot.values()) {
            if (this.onlyArmorSlots && l != AttributeSlot.HEAD && l != AttributeSlot.CHEST && l != AttributeSlot.FEET && l != AttributeSlot.LEGS) continue;
            map.put(l.name(), l);
        }
        return new ArrayList<AttributeSlot>(map.values());
    }

    @Generated
    public Optional<AttributeSlot> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public boolean isOnlyArmorSlots() {
        return this.onlyArmorSlots;
    }

    @Generated
    public void setValue(Optional<AttributeSlot> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<AttributeSlot> defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setOnlyArmorSlots(boolean onlyArmorSlots) {
        this.onlyArmorSlots = onlyArmorSlots;
    }
}

