/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.backward_compatibility.SoundUtils;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SoundFeature
extends FeatureAbstract<Optional<Sound>, SoundFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<Sound> value;
    private Optional<Sound> defaultValue;

    public SoundFeature(FeatureParentInterface parent, Optional<Sound> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        if (colorStr.equals("NULL")) {
            this.value = this.defaultValue;
            return errors;
        }
        try {
            Sound operation = SoundUtils.getSound(colorStr);
            this.value = Optional.ofNullable(operation);
            FeatureReturnCheckPremium<Sound> checkPremium = this.checkPremium("Sound", operation, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            errors.add("&cERROR, Couldn't load the Sound value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> Sound available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Sound.html");
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (((Optional)this.getValue()).isPresent()) {
            if (this.defaultValue.isPresent() && this.isSavingOnlyIfDiffDefault() && ((Sound)((Optional)this.getValue()).get()).equals((Object)this.defaultValue.get())) {
                config.set(this.getName(), null);
                return;
            }
            config.set(this.getName(), (Object)SoundUtils.getSounds().get(((Optional)this.getValue()).get()));
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public Optional<Sound> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public SoundFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        Sound finalValue = ((Optional)value).orElse(Sound.ITEM_ARMOR_EQUIP_DIAMOND);
        this.updateOperation(finalValue, gui);
    }

    @Override
    public SoundFeature clone(FeatureParentInterface newParent) {
        SoundFeature clone = new SoundFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        Sound operation = this.getOperation((GUI)manager.getCache().get(editor));
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        this.updateOperation(operation, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        Sound operation = this.getOperation((GUI)manager.getCache().get(editor));
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        this.updateOperation(operation, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateOperation(this.nextOperation(this.getOperation((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateOperation(this.prevOperation(this.getOperation((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public Sound nextOperation(Sound sound) {
        boolean next = false;
        Map<Object, String> map = SoundUtils.getSounds();
        for (Object check : map.keySet()) {
            if (check.equals(sound)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return (Sound)check;
        }
        return (Sound)map.keySet().iterator().next();
    }

    public Sound prevOperation(Sound sound) {
        int i = -1;
        int cpt = 0;
        Map<Object, String> map = SoundUtils.getSounds();
        for (Object check : map.keySet()) {
            if (check.equals(sound)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return (Sound)map.keySet().toArray()[map.size() - 1];
        }
        return (Sound)map.keySet().toArray()[cpt - 1];
    }

    public void updateOperation(Sound operation, GUI gui) {
        this.value = Optional.of(operation);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        Map<Object, String> map = SoundUtils.getSounds();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += map.size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (Object check : map.keySet()) {
            if (operation == check) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + map.get(operation)));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + map.get(check)));
        }
        for (Object check : map.keySet()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + map.get(check)));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public Sound getOperation(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return SoundUtils.getSound(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    @Generated
    public Optional<Sound> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<Sound> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<Sound> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

