/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.dfsek.terra.bukkit.world.BukkitServerWorld;
import com.ssomar.score.SCore;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.usedapi.AllWorldManager;
import com.ssomar.score.utils.backward_compatibility.BiomeUtils;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class ListBiomeFeature
extends ListFeatureAbstract<String, ListBiomeFeature> {
    public ListBiomeFeature(FeatureParentInterface parent, List<String> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, "List of Biomes", defaultValue, featureSettings);
        this.reset();
    }

    @Override
    public List<String> loadValues(List<String> entries, List<String> errors) {
        ArrayList<String> value = new ArrayList<String>();
        for (String s : entries) {
            s = StringConverter.decoloredString(s);
            boolean found = false;
            for (String biome : this.getBiomes()) {
                if (!biome.equalsIgnoreCase(s)) continue;
                found = true;
                value.add(biome);
                break;
            }
            if (found) continue;
            errors.add("&cERROR, Couldn't load the Biome value of " + this.getName() + " from config, value: " + s + " &7&o" + this.getParent().getParentInfo() + " &6>> Biomes available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/block/Biome.html");
        }
        return value;
    }

    public boolean isValid(Location location) {
        String biome = BiomeUtils.getBiomes().get(location.getBlock().getBiome());
        if (SCore.hasTerra) {
            try {
                BukkitServerWorld worldS = new BukkitServerWorld(location.getWorld());
                biome = worldS.getBiomeProvider().getBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getWorld().getSeed()).getID();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (String biomeStr : this.getValues()) {
            if (!biomeStr.equalsIgnoreCase(biome)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String transfromToString(String value) {
        return value;
    }

    @Override
    public ListBiomeFeature clone(FeatureParentInterface newParent) {
        ListBiomeFeature clone = new ListBiomeFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        message = StringConverter.decoloredString(message);
        for (String biome : this.getBiomes()) {
            if (!biome.equalsIgnoreCase(message)) continue;
            return Optional.empty();
        }
        return Optional.of("&4&l[ERROR] &cThe message you entered is not a Biome &6>> Biomes available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/block/Biome.html");
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        TreeMap<String, Suggestion> map = new TreeMap<String, Suggestion>();
        for (String biome : this.getBiomes()) {
            map.put(biome, new Suggestion(biome, "&6[&e" + biome + "&6]", "&7Add &e" + biome));
        }
        return new ArrayList<Suggestion>(map.values());
    }

    public List<String> getBiomes() {
        ArrayList<String> biomes = new ArrayList<String>();
        if (SCore.hasTerra) {
            for (String worldStr : AllWorldManager.getWorlds()) {
                Optional<World> worldOpt = AllWorldManager.getWorld(worldStr);
                if (!worldOpt.isPresent()) continue;
                World world = worldOpt.get();
                try {
                    BukkitServerWorld worldS = new BukkitServerWorld(world);
                    worldS.getBiomeProvider().getBiomes().forEach(biome -> biomes.add(biome.getID()));
                }
                catch (Exception exception) {}
            }
        }
        biomes.addAll(BiomeUtils.getBiomes().values());
        return biomes;
    }

    @Override
    public String getTips() {
        return "&8Example &7&oFOREST";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, true, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }
}

