/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.usedapi.AllWorldManager;
import com.ssomar.score.usedapi.MultiverseAPI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ListWorldFeature
extends ListFeatureAbstract<String, ListWorldFeature> {
    private static final boolean DEBUG = false;

    public ListWorldFeature(FeatureParentInterface parent, List<String> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, "List of Worlds", defaultValue, featureSettings);
        this.reset();
    }

    @Override
    public List<String> loadValues(List<String> entries, List<String> errors) {
        ArrayList<String> value = new ArrayList<String>();
        for (String s : entries) {
            Optional<World> worldOptional = AllWorldManager.getWorld(s = StringConverter.decoloredString(s));
            if (worldOptional.isPresent()) {
                value.add(s);
                continue;
            }
            errors.add("&cERROR, Couldn't load the World value of " + this.getName() + " from config, value: " + s + " &7&o" + this.getParent().getParentInfo());
        }
        return value;
    }

    @Override
    public String transfromToString(String value) {
        return value;
    }

    @Override
    public ListWorldFeature clone(FeatureParentInterface newParent) {
        ListWorldFeature clone = new ListWorldFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        World w = MultiverseAPI.getWorld(message = StringConverter.decoloredString(message));
        if (w == null) {
            return Optional.of("&4&l[ERROR] &cThe message you entered is not a world, please try again.");
        }
        return Optional.empty();
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        TreeMap<String, Suggestion> map = new TreeMap<String, Suggestion>();
        for (String s : MultiverseAPI.getWorlds()) {
            map.put(s, new Suggestion(s, "&6[&e" + s + "&6]", "&7Add &e" + s));
        }
        return new ArrayList<Suggestion>(map.values());
    }

    @Override
    public String getTips() {
        return "&8Example &7&oworld &7(&awhitelisted&7) &8- &7&o!world &7(&cblacklisted&7)";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, false, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }

    public boolean isValidWorld(@NotNull World world) {
        boolean forValuesBool = this.isValidWorld(true, this.getValues(), world);
        SsomarDev.testMsg(">> verif forValuesBool: " + forValuesBool, false);
        boolean forBlacklistValuesBool = this.isValidWorld(false, this.getBlacklistedValues(), world);
        SsomarDev.testMsg(">> verif forBlacklistValuesBool: " + forBlacklistValuesBool, false);
        return forValuesBool && !forBlacklistValuesBool;
    }

    public boolean isValidWorld(boolean ifEmpty, List<String> references, @NotNull World world) {
        for (String s : references) {
            SsomarDev.testMsg(">> verif references: " + s, false);
        }
        if (references.isEmpty()) {
            return ifEmpty;
        }
        for (String ref : references) {
            World worldRed;
            Optional<World> worldOptional = AllWorldManager.getWorld(ref);
            if (!worldOptional.isPresent() || (worldRed = worldOptional.get()) != world) continue;
            return true;
        }
        return false;
    }
}

