/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.menu.particles;

import com.ssomar.score.menu.GUI;
import com.ssomar.score.menu.GUIAbstract;
import com.ssomar.score.sparticles.SParticle;
import com.ssomar.score.sparticles.SParticles;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.CustomColor;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.List;
import lombok.Generated;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SParticleGUI
extends GUIAbstract {
    public static final String ID = "ID:";
    public static final String TYPE = "Particle Type";
    public static final String AMOUNT = "Particle Amount";
    public static final String OFFSET = "Particle OffSet";
    public static final String SPEED = "Particle Speed";
    public static final String DELAY = "Particle Delay";
    public static final String REDSTONE_COLOR = "Redstone color";
    public static final String BLOCK_TYPE = "Block type";
    private final SParticles sParticles;
    private final GUI guiFrom;
    private boolean newRequiredEI = false;

    public SParticleGUI(SPlugin sPlugin, SParticles sParticles, GUI guiFrom) {
        super("&8&l" + sPlugin.getShortName() + " Editor - Particle", 36, sPlugin);
        this.sParticles = sParticles;
        this.guiFrom = guiFrom;
        this.newRequiredEI = true;
        int id = 1;
        List<SParticle> particles = sParticles.getParticles();
        for (int i = 0; i < particles.size(); ++i) {
            for (SParticle sParticle : particles) {
                if (!sParticle.getId().equals(id + "")) continue;
                ++id;
            }
        }
        String idStr = id + "";
        SParticle sParticle = new SParticle(idStr);
        this.fillTheGUI(sParticle);
    }

    public SParticleGUI(SPlugin sPlugin, SParticles sParticles, SParticle sParticle, GUI guiFrom) {
        super("&8&l" + sPlugin.getShortName() + " Editor - Particle", 36, sPlugin);
        this.sParticles = sParticles;
        this.guiFrom = guiFrom;
        this.fillTheGUI(sParticle);
    }

    public void fillTheGUI(SParticle sParticle) {
        this.createItem(Material.NETHER_STAR, 1, 0, TITLE_COLOR + TYPE, false, false, "", "&a\u270e Click here to change", "&7Currently:");
        this.updateType(sParticle.getParticlesType());
        this.createItem(Material.HOPPER, 1, 1, TITLE_COLOR + AMOUNT, false, false, "", "&a\u270e Click here to change", "&7Currently:");
        this.updateInt(AMOUNT, sParticle.getParticlesAmount());
        this.createItem(Material.LEVER, 1, 2, TITLE_COLOR + OFFSET, false, false, "", "&a\u270e Click here to change", "&7Currently:");
        this.updateDouble(OFFSET, sParticle.getParticlesOffSet());
        this.createItem(Material.LEVER, 1, 3, TITLE_COLOR + SPEED, false, false, "", "&a\u270e Click here to change", "&7Currently:");
        this.updateDouble(SPEED, sParticle.getParticlesSpeed());
        this.createItem(Material.LEVER, 1, 4, TITLE_COLOR + DELAY, false, false, "", "&a\u270e Click here to change", "&7Currently:");
        this.updateInt(DELAY, sParticle.getParticlesDelay());
        if (sParticle.canHaveBlocktype()) {
            this.createItem(Material.STONE, 1, 5, TITLE_COLOR + BLOCK_TYPE, false, false, "", "&a\u270e Click here to change", "&7Currently:");
            this.updateMaterial(sParticle.getBlockType());
        } else if (sParticle.canHaveRedstoneColor()) {
            this.createItem(Material.REDSTONE, 1, 5, TITLE_COLOR + REDSTONE_COLOR, false, false, "", "&a\u270e Click here to change", "&7Currently:");
            this.updateColor(sParticle.getRedstoneColor());
        }
        this.createItem(Material.BOOK, 1, 8, "&a&lID:", false, false, "", "&7Currently: &e" + sParticle.getId());
        this.createItem(ORANGE, 1, 28, "&4&l\u2718 &cReset", false, false, "", "&c&oClick here to reset", "&c&oall options of this particle");
        this.createItem(RED, 1, 27, "&4&l\u25b6&c Back to the list of particle", false, false, new String[0]);
        this.createItem(GREEN, 1, 35, "&2&l\u2714 &aSave this particle", false, false, "", "&a&oClick here to save this", "&a&oparticle");
    }

    public Color nextColor(Color particle) {
        boolean next = false;
        for (Color check : CustomColor.values()) {
            if (check.equals((Object)particle)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return CustomColor.values()[0];
    }

    public Color prevColor(Color color) {
        int i = -1;
        int cpt = 0;
        for (Color check : CustomColor.values()) {
            if (check.equals((Object)color)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return CustomColor.values()[CustomColor.values().length - 1];
        }
        return CustomColor.values()[cpt - 1];
    }

    public void updateColor(Color color) {
        ItemStack item = this.getByIdentifier(REDSTONE_COLOR);
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, 2);
        boolean find = false;
        for (Color check : CustomColor.values()) {
            if (color.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + CustomColor.getName(color)));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + CustomColor.getName(check)));
        }
        for (Color check : CustomColor.values()) {
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + CustomColor.getName(check)));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI((GUI)this, REDSTONE_COLOR, meta.getDisplayName(), lore, item.getType());
    }

    public Color getColor() {
        ItemStack item = this.getByIdentifier(REDSTONE_COLOR);
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return CustomColor.valueOf(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public Particle nextType(Particle particle) {
        boolean next = false;
        for (Particle check : Particle.values()) {
            if (check.equals((Object)particle)) {
                next = true;
                continue;
            }
            if (!next || particle.name().equalsIgnoreCase("VIBRATION") || particle.name().equalsIgnoreCase("SHRIEK") || particle.name().equalsIgnoreCase("SCULK_CHARGE")) continue;
            return check;
        }
        return Particle.values()[0];
    }

    public Particle prevType(Particle particle) {
        int i = -1;
        int cpt = 0;
        for (Particle check : Particle.values()) {
            if (check.equals((Object)particle)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            if (Particle.values()[Particle.values().length - 1].name().equalsIgnoreCase("VIBRATION") || Particle.values()[Particle.values().length - 1].name().equalsIgnoreCase("SHRIEK") || Particle.values()[Particle.values().length - 1].name().equalsIgnoreCase("SCULK_CHARGE")) {
                return this.prevType(Particle.values()[Particle.values().length - 1]);
            }
            return Particle.values()[Particle.values().length - 1];
        }
        return Particle.values()[cpt - 1];
    }

    public void updateType(Particle particle) {
        if (SParticle.getHaveBlocktypeParticles().contains(particle)) {
            this.createItem(Material.STONE, 1, 5, TITLE_COLOR + BLOCK_TYPE, false, false, "", "&a\u270e Click here to change", "&7Currently:");
            this.updateMaterial(Material.STONE);
        } else if (SParticle.getHaveRedstoneColorParticles().contains(particle)) {
            this.createItem(Material.REDSTONE, 1, 5, TITLE_COLOR + REDSTONE_COLOR, false, false, "", "&a\u270e Click here to change", "&7Currently:");
            this.updateColor(Color.RED);
        } else {
            this.createBackGroundItem(5);
        }
        ItemStack item = this.getByIdentifier(TYPE);
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, 2);
        boolean find = false;
        for (Particle check : Particle.values()) {
            if (particle.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + particle));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check));
        }
        for (Particle check : Particle.values()) {
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI((GUI)this, TYPE, meta.getDisplayName(), lore, item.getType());
    }

    public Particle getType() {
        ItemStack item = this.getByIdentifier(TYPE);
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return Particle.valueOf((String)str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public void updateMaterial(Material material) {
        ItemStack item = this.getByIdentifier(BLOCK_TYPE);
        this.updateCurrently(item, "&e" + material);
    }

    public Material getMaterial() {
        ItemStack item = this.getByIdentifier(BLOCK_TYPE);
        return Material.valueOf((String)this.getCurrently(item));
    }

    public boolean isNewRequiredEI() {
        return this.newRequiredEI;
    }

    public void setNewRequiredEI(boolean newRequiredEI) {
        this.newRequiredEI = newRequiredEI;
    }

    @Override
    public void reloadGUI() {
    }

    @Generated
    public SParticles getSParticles() {
        return this.sParticles;
    }

    @Generated
    public GUI getGuiFrom() {
        return this.guiFrom;
    }
}

