/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.pack.spigot.interceptor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Bukkit;

public class ClientConnectionInterceptor {
    public void install(final Consumer<Channel> channelConsumer) {
        ChannelInitializer<Channel> beginInitProtocol = new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                try {
                    channelConsumer.accept(channel);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot inject incoming channel " + channel, e);
                }
            }
        };
        ChannelInboundHandlerAdapter serverHandler = new ChannelInboundHandlerAdapter((ChannelInitializer)beginInitProtocol){
            final /* synthetic */ ChannelInitializer val$beginInitProtocol;
            {
                this.val$beginInitProtocol = channelInitializer;
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                Channel channel = (Channel)msg;
                channel.pipeline().addFirst(new ChannelHandler[]{this.val$beginInitProtocol});
                ctx.fireChannelRead(msg);
            }
        };
        List<ChannelFuture> channels = this.getChannels();
        for (ChannelFuture channelFuture : channels) {
            channelFuture.channel().pipeline().addFirst(new ChannelHandler[]{serverHandler});
        }
    }

    private Method getMethodByReturnType(Class<?> clazz, Class<?> returnType) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.getReturnType().equals(returnType)).findFirst().orElse(null);
    }

    private Field getFieldByTypeAndPredicate(Class<?> clazz, Class<?> type, Function<Field, Boolean> predicate) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getType().equals(type) && (Boolean)predicate.apply((Field)field) != false).findFirst().orElse(null);
    }

    private List<ChannelFuture> getChannels() {
        try {
            Class<?> minecraftServerClass = Class.forName("net.minecraft.server.MinecraftServer");
            Class<?> craftServerClass = this.getCraftServerClass();
            Object craftServerObject = craftServerClass.cast(Bukkit.getServer());
            Method craftServerGetServerMethod = craftServerClass.getDeclaredMethod("getServer", new Class[0]);
            Object minecraftServer = craftServerGetServerMethod.invoke(craftServerObject, new Object[0]);
            Object serverConnection = this.getServerConnection(minecraftServer, minecraftServerClass);
            Field channelsField = this.getFieldByTypeAndPredicate(serverConnection.getClass(), List.class, field -> Modifier.isPrivate(field.getModifiers()));
            if (channelsField == null) {
                channelsField = this.findChannelsField(serverConnection.getClass());
            }
            if (channelsField == null) {
                throw new RuntimeException("Could not find channels field in ServerConnection");
            }
            channelsField.setAccessible(true);
            return (List)channelsField.get(serverConnection);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> getCraftServerClass() throws ClassNotFoundException {
        try {
            return Class.forName("org.bukkit.craftbukkit.CraftServer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            String serverVersion = this.getServerVersion();
            return Class.forName("org.bukkit.craftbukkit." + serverVersion + ".CraftServer");
        }
    }

    private Object getServerConnection(Object minecraftServer, Class<?> minecraftServerClass) throws InvocationTargetException, IllegalAccessException {
        Method getConnectionMethod;
        Class<?> serverConnectionClass = null;
        try {
            serverConnectionClass = Class.forName("net.minecraft.server.network.ServerConnectionListener");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (serverConnectionClass == null) {
            try {
                serverConnectionClass = Class.forName("net.minecraft.server.network.ServerConnection");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not find ServerConnection or ServerConnectionListener class", e);
            }
        }
        if ((getConnectionMethod = this.getMethodByReturnType(minecraftServerClass, serverConnectionClass)) != null) {
            return getConnectionMethod.invoke(minecraftServer, new Object[0]);
        }
        for (Field field : minecraftServerClass.getDeclaredFields()) {
            if (!field.getType().equals(serverConnectionClass)) continue;
            field.setAccessible(true);
            return field.get(minecraftServer);
        }
        for (Field field : minecraftServerClass.getDeclaredFields()) {
            String className;
            field.setAccessible(true);
            Object value = field.get(minecraftServer);
            if (value == null || !(className = value.getClass().getName()).contains("ServerConnection")) continue;
            return value;
        }
        throw new RuntimeException("Could not find ServerConnection/ServerConnectionListener in MinecraftServer");
    }

    private Field findChannelsField(Class<?> clazz) {
        for (Class<?> currentClass = clazz; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (!field.getType().equals(List.class) || !Modifier.isPrivate(field.getModifiers())) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return null;
    }

    private String getServerVersion() {
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        return packageName.substring(packageName.lastIndexOf(46) + 1);
    }
}

