/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.projectiles.loader;

import com.ssomar.score.SCore;
import com.ssomar.score.projectiles.SProjectile;
import com.ssomar.score.projectiles.loader.ConfigConverter;
import com.ssomar.score.projectiles.manager.SProjectilesManager;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class SProjectileLoader
extends SObjectWithFileLoader<SProjectile> {
    private static SProjectileLoader instance;
    private static final String DEFAULT = "Default";

    public SProjectileLoader() {
        super(SCore.plugin, "/com/ssomar/score/configs/projectiles/", SProjectilesManager.getInstance(), 1000);
    }

    @Override
    public void load() {
        SProjectilesManager.getInstance().setDefaultObjects(new ArrayList());
        this.loadDefaultPremiumObjects();
        SProjectilesManager.getInstance().setLoadedObjects(new ArrayList());
        this.resetCpt();
        File itemsDirectory = new File(SCore.plugin.getDataFolder() + "/projectiles");
        if (itemsDirectory.exists()) {
            this.loadObjectsInFolder(itemsDirectory, true);
        } else {
            this.createDefaultObjectsFile(true);
            this.load();
        }
        File notEditProjDirectory = new File(SCore.plugin.getDataFolder() + "/projectiles/projectiles_not_editable");
        if (!notEditProjDirectory.exists()) {
            notEditProjDirectory.mkdirs();
        }
        this.loadObjectsInFolder(notEditProjDirectory, true);
    }

    public Map<String, List<String>> getNotEditableProjectilesName() {
        HashMap<String, List<String>> defaultBlocks = new HashMap<String, List<String>>();
        ArrayList<String> defaultProj = new ArrayList<String>();
        defaultProj.add("DEFAULT_INVISIBLE_ARROW");
        defaultProj.add("DEFAULT_INVISIBLE_ARROW_NO_GRAVITY");
        defaultProj.add("DEFAULT_INVISIBLE_ARROW_NO_GRAVITY_SPEED");
        defaultProj.add("FAIRYTAIL_GRAY_FULLBUSTER_1");
        defaultProj.add("FAIRYTAIL_NATSU_DRAGNEEL_1");
        defaultProj.add("FATE_ARCHER_1");
        defaultProj.add("FATE_ARCHER_2");
        defaultProj.add("FATE_CASTER_1");
        defaultProj.add("FATE_CASTER_2");
        defaultProj.add("FATE_CASTER_3");
        defaultProj.add("FATE_GILGAMESH_1");
        defaultProj.add("FATE_GILGAMESH_2");
        defaultProj.add("FATE_GILGAMESH_3");
        defaultProj.add("FATE_RIDER_1");
        defaultProj.add("HUNTERXHUNTER_GON_FREECSS_1");
        defaultProj.add("HUNTERXHUNTER_KURAPIKA_1");
        defaultProj.add("MADOKA_HOMURA_AKEMI_1");
        defaultProj.add("MADOKA_MADOKA_KANAME_1");
        defaultProj.add("MADOKA_MAMI_TOMOE_1");
        defaultProj.add("MHA_DENKI_KAMINARI_1");
        defaultProj.add("MHA_IZUKU_MIDORIYA_1");
        defaultProj.add("MHA_MINA_ASHIDO_ACID_1");
        defaultProj.add("MHA_MINA_ASHIDO_ACID_2");
        defaultProj.add("MHA_SHOTO_TODOROKI_2");
        defaultProj.add("ONEPIECE_001_1_FIRE_FIST");
        defaultProj.add("ONEPIECE_001_2_FIRE_GUN");
        defaultProj.add("ONEPIECE_001_3_FIREFLY");
        defaultProj.add("ONEPIECE_002_1_FREEZE_BEAM");
        defaultProj.add("ONEPIECE_002_2_FREEZE_BOMB");
        defaultProj.add("ONEPIECE_003_1_TELEPORT");
        defaultProj.add("ONEPIECE_003_2_LIGHTNING_STRIKE");
        defaultProj.add("ONEPIECE_004_1_BLACK_HOLE");
        defaultProj.add("ONEPIECE_005_1_FLIGHT");
        defaultProj.add("ONEPIECE_005_2_FLAME_WALL");
        defaultProj.add("ONEPIECE_005_3_FIREBALL");
        defaultProj.add("OPM_GENOS_1");
        defaultProj.add("OPM_SPEED_O_SONIC_1");
        defaultProj.add("PACK_2_06");
        defaultProj.add("PACK_2_12");
        defaultProj.add("proj_rainbow_projectile");
        defaultProj.add("proj_tornado_blade");
        defaultProj.add("proj_pumpkin");
        defaultProj.add("BLACK_HOLE_PROJECTILE");
        defaultProj.add("FIRE_WAND_PROJECTILE");
        defaultBlocks.put(DEFAULT, defaultProj);
        return defaultBlocks;
    }

    @Override
    public void configVersionsConverter(File file) {
        ConfigConverter.updateTo(file);
    }

    @Override
    public Optional<SProjectile> getObject(FileConfiguration itemConfig, String id, boolean showError, boolean isPremiumLoading, String path) {
        SProjectile item = new SProjectile(id, path);
        ArrayList<String> errors = new ArrayList<String>(item.load(SCore.plugin, (ConfigurationSection)itemConfig, isPremiumLoading));
        if (showError) {
            for (String s : errors) {
                SCore.plugin.getServer().getLogger().severe(s);
            }
        }
        return Optional.ofNullable(item);
    }

    public static SProjectileLoader getInstance() {
        if (instance == null) {
            instance = new SProjectileLoader();
        }
        return instance;
    }
}

