/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.usedapi;

import com.ssomar.executableblocks.executableblocks.placedblocks.ExecutableBlockPlaced;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.api.executableblocks.ExecutableBlocksAPI;
import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.CustomFurniture;
import dev.lone.itemsadder.api.CustomStack;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class ItemsAdderAPI {
    public static boolean breakCustomBlock(final Block block, ItemStack item, boolean drop) {
        SsomarDev.testMsg(ChatColor.GOLD + "[#s0003] breakCustomBlock() method call from ItemsAdderAPI.java", true);
        if (SCore.hasItemsAdder && block != null && !block.isEmpty()) {
            if (SCore.hasClass("dev.lone.itemsadder.api.CustomBlock")) {
                SsomarDev.testMsg("> [#s0004] Attempted to break ItemsAdder block", true);
                CustomBlock customBlock = CustomBlock.byAlreadyPlaced((Block)block);
                if (customBlock != null) {
                    Optional eBPOpt;
                    SsomarDev.testMsg("> > [#s0005] Custom Block is not null", true);
                    if (drop) {
                        List loots = customBlock.getLoot(item, false);
                        for (ItemStack loot : loots) {
                            block.getWorld().dropItemNaturally(block.getLocation(), loot);
                        }
                    }
                    customBlock.playBreakSound();
                    customBlock.playBreakEffect();
                    customBlock.playBreakParticles();
                    customBlock.remove();
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            block.setType(Material.AIR);
                        }
                    };
                    if (SCore.hasExecutableBlocks && (eBPOpt = ExecutableBlocksAPI.getExecutableBlocksPlacedManager().getExecutableBlockPlaced(block)).isPresent()) {
                        SsomarDev.testMsg("> > > > [#s0031] EXECUTABLE_BLOCK detected on location, attempting to drop & delete", true);
                        ExecutableBlockPlaced eBP = (ExecutableBlockPlaced)eBPOpt.get();
                        ItemsAdderAPI.tryToDropExecutableBlock(eBP, block, drop);
                        eBP.remove();
                    }
                    SCore.schedulerHook.runTask(runnable, 1L);
                    return true;
                }
            }
            SsomarDev.testMsg("> [#s0025] Start iterating through nearby entities " + block.getLocation().getWorld().getNearbyEntities(block.getLocation(), 0.5, 0.5, 0.5).size() + "; Block: " + block.getLocation(), true);
            for (Entity e : block.getLocation().getWorld().getNearbyEntities(block.getLocation(), 0.5, 0.5, 0.5)) {
                if (!(e instanceof ArmorStand)) continue;
                SsomarDev.testMsg("> [#s0006] Custom Block instanceof ArmorStand", true);
                ArmorStand armorStand = (ArmorStand)e;
                if (armorStand.getCustomName() != null && armorStand.getCustomName().equals("ItemsAdder_furniture")) {
                    SsomarDev.testMsg("> > [#s0007] Armorstand has a name and ArmorStand name is \"ItemsAdder_furniture\". Target at: " + e.getLocation(), false);
                    if (e.getX() == (double)block.getX() + 0.5 && e.getY() == (double)block.getY() && e.getZ() == (double)block.getZ() + 0.5) {
                        Optional eBPOpt;
                        SsomarDev.testMsg("> > > [#s0027] Block finally removed", true);
                        CustomFurniture furniture = CustomFurniture.byAlreadySpawned((Entity)armorStand);
                        furniture.remove(false);
                        if (e != null) {
                            e.remove();
                        }
                        if (SCore.hasExecutableBlocks && (eBPOpt = ExecutableBlocksAPI.getExecutableBlocksPlacedManager().getExecutableBlockPlaced(block)).isPresent()) {
                            SsomarDev.testMsg("> > > > [#s0029] EXECUTABLE_BLOCK detected on location, attempting to drop:" + drop + " & delete", true);
                            ExecutableBlockPlaced eBP = (ExecutableBlockPlaced)eBPOpt.get();
                            ItemsAdderAPI.tryToDropExecutableBlock(eBP, block, drop);
                            eBP.remove();
                        }
                        return true;
                    }
                    SsomarDev.testMsg(ChatColor.RED + "> > [#s0028] FAIL: " + (e.getX() == (double)block.getX() + 0.5) + " " + (e.getY() == (double)block.getY()) + " " + (e.getZ() == (double)block.getZ() + 0.5), false);
                    continue;
                }
                if (armorStand.getCustomName() == null) {
                    SsomarDev.testMsg("[#s0008] Armorstand has no name", true);
                    continue;
                }
                SsomarDev.testMsg("[#s0009] Armorstand is not IA; name is: " + armorStand.getCustomName(), true);
            }
        }
        return false;
    }

    private static void tryToDropExecutableBlock(ExecutableBlockPlaced eBP, Block block, boolean drop) {
        if (eBP.getExecutableBlock().getDropBlockIfItIsBroken().getValue().booleanValue() && drop) {
            eBP.dropAtLocation(block.getLocation(), eBP.getExecutableBlock().getResetInternalDatasWhenBroken().getValue().booleanValue());
        }
    }

    public static Optional<String> getCustomBlockID(Block block) {
        if (SCore.hasItemsAdder && block != null && !block.isEmpty()) {
            CustomBlock customBlock;
            if (SCore.hasClass("dev.lone.itemsadder.api.CustomBlock") && (customBlock = CustomBlock.byAlreadyPlaced((Block)block)) != null) {
                return Optional.of(customBlock.getId());
            }
            for (Entity e : block.getLocation().getWorld().getNearbyEntities(block.getLocation(), 0.5, 0.5, 0.5)) {
                ArmorStand armorStand;
                if (!(e instanceof ArmorStand) || (armorStand = (ArmorStand)e).getCustomName() == null || !armorStand.getCustomName().equals("ItemsAdder_furniture")) continue;
                return Optional.of(CustomFurniture.byAlreadySpawned((Entity)armorStand).getId());
            }
        }
        return Optional.empty();
    }

    public static Optional<String> getCustomItemID(ItemStack item) {
        CustomStack customStack;
        if (SCore.hasItemsAdder && item != null && (customStack = CustomStack.byItemStack((ItemStack)item)) != null) {
            return Optional.of(customStack.getId());
        }
        return Optional.empty();
    }

    public static boolean isCustomBlock(Block block) {
        return ItemsAdderAPI.getCustomBlockID(block).isPresent();
    }

    public static boolean isCustomItem(ItemStack item) {
        return ItemsAdderAPI.getCustomItemID(item).isPresent();
    }

    public static boolean placeItemAdder(Location location, String id) {
        try {
            CustomBlock customBlock = CustomBlock.getInstance((String)id);
            if (customBlock != null) {
                customBlock.place(location);
                return true;
            }
        }
        catch (Error | Exception e) {
            try {
                CustomFurniture.spawnPreciseNonSolid((String)id, (Location)location);
                return true;
            }
            catch (Exception e1) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

