/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.usedapi;

import com.ssomar.score.SCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MyCoreProtectAPI {
    private static final Map<String, CachedResult> naturalBlockCache = new ConcurrentHashMap<String, CachedResult>();
    private static final long CACHE_EXPIRY_MS = 300000L;
    private static final int LOOKUP_TIME_SECONDS = 604800;

    private static String getCacheKey(Block block) {
        return block.getWorld().getName() + ":" + block.getX() + ":" + block.getY() + ":" + block.getZ();
    }

    private static CoreProtectAPI getCoreProtectAPI() {
        if (!SCore.hasCoreProtect) {
            return null;
        }
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("CoreProtect");
        if (plugin == null || !plugin.isEnabled()) {
            return null;
        }
        if (!(plugin instanceof CoreProtect)) {
            return null;
        }
        CoreProtectAPI api = ((CoreProtect)plugin).getAPI();
        if (!api.isEnabled()) {
            return null;
        }
        if (api.APIVersion() < 9) {
            return null;
        }
        return api;
    }

    public static void logRemoval(String user, Location location, Material type, BlockData blockData) {
        if (SCore.hasCoreProtect) {
            Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("CoreProtect");
            if (!plugin.isEnabled()) {
                return;
            }
            if (!(plugin instanceof CoreProtect)) {
                return;
            }
            CoreProtectAPI CoreProtect2 = ((CoreProtect)plugin).getAPI();
            if (!CoreProtect2.isEnabled()) {
                return;
            }
            if (CoreProtect2.APIVersion() < 9) {
                return;
            }
            CoreProtect2.logRemoval(user, location, type, blockData);
        }
    }

    public static boolean isNaturalBlock(Block block) {
        if (!SCore.hasCoreProtect) {
            return false;
        }
        CoreProtectAPI api = MyCoreProtectAPI.getCoreProtectAPI();
        if (api == null) {
            return false;
        }
        String cacheKey = MyCoreProtectAPI.getCacheKey(block);
        CachedResult cached = naturalBlockCache.get(cacheKey);
        if (cached != null && !cached.isExpired()) {
            return cached.isNatural;
        }
        if (cached != null) {
            naturalBlockCache.remove(cacheKey);
        }
        MyCoreProtectAPI.lookupBlockAsync(block, api, cacheKey);
        return false;
    }

    private static void lookupBlockAsync(Block block, CoreProtectAPI api, String cacheKey) {
        CompletableFuture.runAsync(() -> {
            try {
                List list = api.blockLookup(block, 604800);
                boolean isNatural = list == null || list.isEmpty();
                naturalBlockCache.put(cacheKey, new CachedResult(isNatural));
            }
            catch (Exception e) {
                naturalBlockCache.put(cacheKey, new CachedResult(false));
            }
        });
    }

    public static void invalidateCache(Block block) {
        naturalBlockCache.remove(MyCoreProtectAPI.getCacheKey(block));
    }

    public static void clearCache() {
        naturalBlockCache.clear();
    }

    public void addPickup(Location location, ItemStack itemStack, Player player) {
        if (SCore.hasCoreProtect) {
            Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("CoreProtect");
            if (plugin != null && !plugin.isEnabled()) {
                return;
            }
            if (!(plugin instanceof CoreProtect)) {
                return;
            }
            CoreProtectAPI CoreProtect2 = ((CoreProtect)plugin).getAPI();
            if (!CoreProtect2.isEnabled()) {
                return;
            }
            if (CoreProtect2.APIVersion() < 9) {
                return;
            }
            if (!Config.getConfig((World)location.getWorld()).ITEM_PICKUPS) {
                return;
            }
            if (itemStack == null) {
                return;
            }
            String loggingItemId = player.getName().toLowerCase(Locale.ROOT) + "." + location.getBlockX() + "." + location.getBlockY() + "." + location.getBlockZ();
            new Register();
            int itemId = Register.getItem(loggingItemId);
            List list = ConfigHandler.itemsPickup.getOrDefault(loggingItemId, new ArrayList());
            list.add(itemStack.clone());
            ConfigHandler.itemsPickup.put(loggingItemId, list);
            int time = (int)(System.currentTimeMillis() / 1000L) + 1;
            new Register().addItemTransaction(player, location.clone(), time, itemId);
        }
    }

    private static class CachedResult {
        final boolean isNatural;
        final long timestamp;

        CachedResult(boolean isNatural) {
            this.isNatural = isNatural;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 300000L;
        }
    }

    static class Register
    extends Queue {
        public static int getItem(String loggingItemId) {
            return Register.getItemId((String)loggingItemId);
        }

        public void addItemTransaction(Player player, Location location, int time, int itemId) {
            Queue.queueItemTransaction((String)player.getName(), (Location)location.clone(), (int)time, (int)0, (int)itemId);
        }
    }
}

