/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.usedapi;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Pair;
import com.comphenix.protocol.wrappers.WrappedParticle;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ProtocolLibAPI {
    public static List<ScheduledTask> sendEquipmentVisualReplace(Player player, EquipmentSlot slot, Material material, int amount, int time) {
        return ProtocolLibAPI.sendEquipmentVisualReplace((LivingEntity)player, slot, new ItemStack(material, amount), time);
    }

    public static List<ScheduledTask> sendEquipmentVisualReplace(final LivingEntity entity, final EquipmentSlot slot, final ItemStack item, int time) {
        ArrayList<ScheduledTask> tasks = new ArrayList<ScheduledTask>();
        if (!Dependency.PROTOCOL_LIB.isEnabled()) {
            return tasks;
        }
        for (int i = 0; i < time; ++i) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PacketContainer packet = SCore.protocolManager.createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                    packet.getIntegers().write(0, (Object)entity.getEntityId());
                    ArrayList<Pair> pairList = new ArrayList<Pair>();
                    if (slot.equals((Object)EquipmentSlot.HEAD)) {
                        pairList.add(new Pair((Object)EnumWrappers.ItemSlot.HEAD, (Object)item));
                    } else if (slot.equals((Object)EquipmentSlot.CHEST)) {
                        pairList.add(new Pair((Object)EnumWrappers.ItemSlot.CHEST, (Object)item));
                    } else if (slot.equals((Object)EquipmentSlot.LEGS)) {
                        pairList.add(new Pair((Object)EnumWrappers.ItemSlot.LEGS, (Object)item));
                    } else if (slot.equals((Object)EquipmentSlot.FEET)) {
                        pairList.add(new Pair((Object)EnumWrappers.ItemSlot.FEET, (Object)item));
                    } else if (slot.equals((Object)EquipmentSlot.HAND)) {
                        pairList.add(new Pair((Object)EnumWrappers.ItemSlot.MAINHAND, (Object)item));
                    } else if (slot.equals((Object)EquipmentSlot.OFF_HAND)) {
                        pairList.add(new Pair((Object)EnumWrappers.ItemSlot.OFFHAND, (Object)item));
                    }
                    packet.getSlotStackPairLists().write(0, pairList);
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        try {
                            SCore.protocolManager.sendServerPacket(p, packet);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            tasks.add(SCore.schedulerHook.runAsyncTask(runnable, i));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PacketContainer packet = SCore.protocolManager.createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
                packet.getIntegers().write(0, (Object)entity.getEntityId());
                ArrayList<Pair<EnumWrappers.ItemSlot, ItemStack>> pairList = new ArrayList<Pair<EnumWrappers.ItemSlot, ItemStack>>();
                EntityEquipment equipment = entity.getEquipment();
                if (equipment == null) {
                    return;
                }
                if (slot.equals((Object)EquipmentSlot.HEAD)) {
                    pairList.add(ProtocolLibAPI.get(EnumWrappers.ItemSlot.HEAD, equipment.getHelmet()));
                } else if (slot.equals((Object)EquipmentSlot.CHEST)) {
                    pairList.add(ProtocolLibAPI.get(EnumWrappers.ItemSlot.CHEST, equipment.getChestplate()));
                } else if (slot.equals((Object)EquipmentSlot.LEGS)) {
                    pairList.add(ProtocolLibAPI.get(EnumWrappers.ItemSlot.LEGS, equipment.getLeggings()));
                } else if (slot.equals((Object)EquipmentSlot.FEET)) {
                    pairList.add(ProtocolLibAPI.get(EnumWrappers.ItemSlot.FEET, equipment.getBoots()));
                } else if (slot.equals((Object)EquipmentSlot.HAND)) {
                    pairList.add(ProtocolLibAPI.get(EnumWrappers.ItemSlot.MAINHAND, equipment.getItemInMainHand()));
                } else if (slot.equals((Object)EquipmentSlot.OFF_HAND)) {
                    pairList.add(ProtocolLibAPI.get(EnumWrappers.ItemSlot.OFFHAND, equipment.getItemInOffHand()));
                }
                packet.getSlotStackPairLists().write(0, pairList);
                for (Player p : Bukkit.getOnlinePlayers()) {
                    try {
                        SCore.protocolManager.sendServerPacket(p, packet);
                        SsomarDev.testMsg("send packet RESET EQUIPMENT", true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        tasks.add(SCore.schedulerHook.runTask(runnable, time));
        return tasks;
    }

    public static Pair<EnumWrappers.ItemSlot, ItemStack> get(EnumWrappers.ItemSlot slot, ItemStack item) {
        if (item == null) {
            return new Pair((Object)slot, (Object)new ItemStack(Material.AIR));
        }
        return new Pair((Object)slot, (Object)item);
    }

    public static void reduceDamageIndicator() {
        if (Dependency.PROTOCOL_LIB.isEnabled() && !SCore.is1v11Less() && GeneralConfig.getInstance().isReduceDamageIndicatorWithProtolcolLib()) {
            try {
                SCore.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)SCore.plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.WORLD_PARTICLES}){

                    public void onPacketReceiving(PacketEvent event) {
                    }

                    public void onPacketSending(PacketEvent event) {
                        block6: {
                            if (event.getPacketType() == PacketType.Play.Server.WORLD_PARTICLES) {
                                try {
                                    Particle type = ((WrappedParticle)event.getPacket().getNewParticles().read(0)).getParticle();
                                    if (!type.equals((Object)Particle.DAMAGE_INDICATOR)) break block6;
                                    try {
                                        Field privateField = event.getPacket().getHandle().getClass().getDeclaredField("h");
                                        privateField.setAccessible(true);
                                        int amount = privateField.getInt(event.getPacket().getHandle());
                                        if (amount > 10) {
                                            privateField.setInt(event.getPacket().getHandle(), 10);
                                        }
                                    }
                                    catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {}
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                });
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
    }
}

