/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.backward_compatibility;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.utils.MapUtil;
import com.ssomar.score.utils.backward_compatibility.AttributeAdditionMode;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class AttributeUtils {
    private static final boolean DEBUG = true;

    public static Map<Object, String> getAttributes() {
        HashMap<Object, String> list;
        block8: {
            block7: {
                list = new HashMap<Object, String>();
                if (!SCore.is1v21v2Plus()) break block7;
                for (Keyed l : Registry.ATTRIBUTE) {
                    NamespacedKey key = l.getKey();
                    if (key.getNamespace().equals("minecraft")) {
                        list.put(l, l.getKey().getKey().toUpperCase());
                        continue;
                    }
                    list.put(l, l.getKey().toString());
                }
                break block8;
            }
            if (SCore.is1v8()) break block8;
            for (Attribute o : (Attribute[])Attribute.class.getEnumConstants()) {
                try {
                    String name = (String)o.getClass().getMethod("name", new Class[0]).invoke((Object)o, new Object[0]);
                    list.put(o, name);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return MapUtil.sortByValue(list);
    }

    public static Attribute getAttribute(String string) {
        string = string.replace("minecraft:", "");
        SsomarDev.testMsg(ChatColor.GOLD + "[#s0019] getAttribute() is triggered: " + string, true);
        for (Map.Entry<Object, String> entry : AttributeUtils.getAttributes().entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(string)) continue;
            SsomarDev.testMsg("[#s0020] getAttributes() returns Attribute from iteration", true);
            return (Attribute)entry.getKey();
        }
        SsomarDev.testMsg("[#s0021] getAttributes() checks switch case statement", true);
        try {
            switch (string.toUpperCase()) {
                case "GENERIC_MAX_HEALTH": {
                    return Attribute.MAX_HEALTH;
                }
                case "GENERIC_FOLLOW_RANGE": {
                    return Attribute.FOLLOW_RANGE;
                }
                case "GENERIC_KNOCKBACK_RESISTANCE": {
                    return Attribute.KNOCKBACK_RESISTANCE;
                }
                case "GENERIC_MOVEMENT_SPEED": {
                    return Attribute.MOVEMENT_SPEED;
                }
                case "GENERIC_FLYING_SPEED": {
                    return Attribute.FLYING_SPEED;
                }
                case "GENERIC_ATTACK_DAMAGE": {
                    return Attribute.ATTACK_DAMAGE;
                }
                case "GENERIC_ATTACK_KNOCKBACK": {
                    return Attribute.ATTACK_KNOCKBACK;
                }
                case "GENERIC_ATTACK_SPEED": {
                    return Attribute.ATTACK_SPEED;
                }
                case "GENERIC_ARMOR": {
                    return Attribute.ARMOR;
                }
                case "GENERIC_ARMOR_TOUGHNESS": {
                    return Attribute.ARMOR_TOUGHNESS;
                }
                case "GENERIC_LUCK": {
                    return Attribute.LUCK;
                }
                case "GENERIC_JUMP_STRENGTH": {
                    return Attribute.JUMP_STRENGTH;
                }
                case "GENERIC_FALL_DAMAGE_MULTIPLIER": {
                    return Attribute.FALL_DAMAGE_MULTIPLIER;
                }
                case "GENERIC_MAX_ABSORPTION": {
                    return Attribute.MAX_ABSORPTION;
                }
                case "GENERIC_SAFE_FALL_DISTANCE": {
                    return Attribute.SAFE_FALL_DISTANCE;
                }
                case "GENERIC_SCALE": {
                    return Attribute.SCALE;
                }
                case "GENERIC_STEP_HEIGHT": {
                    return Attribute.STEP_HEIGHT;
                }
                case "GENERIC_GRAVITY": {
                    return Attribute.GRAVITY;
                }
                case "GENERIC_BURNING_TIME": {
                    return Attribute.BURNING_TIME;
                }
                case "GENERIC_EXPLOSION_KNOCKBACK_RESISTANCE": {
                    return Attribute.EXPLOSION_KNOCKBACK_RESISTANCE;
                }
                case "GENERIC_MOVEMENT_EFFICIENCY": {
                    return Attribute.MOVEMENT_EFFICIENCY;
                }
                case "GENERIC_OXYGEN_BONUS": {
                    return Attribute.OXYGEN_BONUS;
                }
                case "GENERIC_WATER_MOVEMENT_EFFICIENCY": {
                    return Attribute.WATER_MOVEMENT_EFFICIENCY;
                }
                case "PLAYER_BLOCK_INTERACTION_RANGE": {
                    return Attribute.BLOCK_INTERACTION_RANGE;
                }
                case "PLAYER_ENTITY_INTERACTION_RANGE": {
                    return Attribute.ENTITY_INTERACTION_RANGE;
                }
                case "PLAYER_BLOCK_BREAK_SPEED": {
                    return Attribute.BLOCK_BREAK_SPEED;
                }
                case "PLAYER_MINING_EFFICIENCY": {
                    return Attribute.MINING_EFFICIENCY;
                }
                case "PLAYER_SNEAKING_SPEED": {
                    return Attribute.SNEAKING_SPEED;
                }
                case "PLAYER_SUBMERGED_MINING_SPEED": {
                    return Attribute.SUBMERGED_MINING_SPEED;
                }
                case "PLAYER_SWEEPING_DAMAGE_RATIO": {
                    return Attribute.SWEEPING_DAMAGE_RATIO;
                }
                case "ZOMBIE_SPAWN_REINFORCEMENTS": {
                    return Attribute.SPAWN_REINFORCEMENTS;
                }
                case "MAX_HEALTH": {
                    return Attribute.MAX_HEALTH;
                }
                case "FOLLOW_RANGE": {
                    return Attribute.FOLLOW_RANGE;
                }
                case "KNOCKBACK_RESISTANCE": {
                    return Attribute.KNOCKBACK_RESISTANCE;
                }
                case "MOVEMENT_SPEED": {
                    return Attribute.MOVEMENT_SPEED;
                }
                case "FLYING_SPEED": {
                    return Attribute.FLYING_SPEED;
                }
                case "ATTACK_DAMAGE": {
                    return Attribute.ATTACK_DAMAGE;
                }
                case "ATTACK_KNOCKBACK": {
                    return Attribute.ATTACK_KNOCKBACK;
                }
                case "ATTACK_SPEED": {
                    return Attribute.ATTACK_SPEED;
                }
                case "ARMOR": {
                    return Attribute.ARMOR;
                }
                case "ARMOR_TOUGHNESS": {
                    return Attribute.ARMOR_TOUGHNESS;
                }
                case "LUCK": {
                    return Attribute.LUCK;
                }
                case "JUMP_STRENGTH": {
                    return Attribute.JUMP_STRENGTH;
                }
                case "FALL_DAMAGE_MULTIPLIER": {
                    return Attribute.FALL_DAMAGE_MULTIPLIER;
                }
                case "MAX_ABSORPTION": {
                    return Attribute.MAX_ABSORPTION;
                }
                case "SAFE_FALL_DISTANCE": {
                    return Attribute.SAFE_FALL_DISTANCE;
                }
                case "SCALE": {
                    return Attribute.SCALE;
                }
                case "STEP_HEIGHT": {
                    return Attribute.STEP_HEIGHT;
                }
                case "GRAVITY": {
                    return Attribute.GRAVITY;
                }
                case "BURNING_TIME": {
                    return Attribute.BURNING_TIME;
                }
                case "EXPLOSION_KNOCKBACK_RESISTANCE": {
                    return Attribute.EXPLOSION_KNOCKBACK_RESISTANCE;
                }
                case "MOVEMENT_EFFICIENCY": {
                    return Attribute.MOVEMENT_EFFICIENCY;
                }
                case "OXYGEN_BONUS": {
                    return Attribute.OXYGEN_BONUS;
                }
                case "WATER_MOVEMENT_EFFICIENCY": {
                    return Attribute.WATER_MOVEMENT_EFFICIENCY;
                }
                case "BLOCK_INTERACTION_RANGE": {
                    return Attribute.BLOCK_INTERACTION_RANGE;
                }
                case "ENTITY_INTERACTION_RANGE": {
                    return Attribute.ENTITY_INTERACTION_RANGE;
                }
                case "BLOCK_BREAK_SPEED": {
                    return Attribute.BLOCK_BREAK_SPEED;
                }
                case "MINING_EFFICIENCY": {
                    return Attribute.MINING_EFFICIENCY;
                }
                case "SNEAKING_SPEED": {
                    return Attribute.SNEAKING_SPEED;
                }
                case "SUBMERGED_MINING_SPEED": {
                    return Attribute.SUBMERGED_MINING_SPEED;
                }
                case "SWEEPING_DAMAGE_RATIO": {
                    return Attribute.SWEEPING_DAMAGE_RATIO;
                }
                case "SPAWN_REINFORCEMENTS": {
                    return Attribute.SPAWN_REINFORCEMENTS;
                }
            }
            return null;
        }
        catch (NoSuchFieldError e) {
            if (!string.contains("GENERIC")) {
                return AttributeUtils.getAttribute("GENERIC_" + string);
            }
            return null;
        }
    }

    public static void addAttributeOnItemMeta(@NotNull ItemMeta meta, Material itemType, LinkedHashMap<Attribute, AttributeModifier> attributes, boolean keepDefaultItemAttributes, boolean keepExistingAttributes, AttributeAdditionMode mode, boolean affectDefaultAttributes) {
        if (!keepExistingAttributes) {
            SsomarDev.testMsg("REMOVE ALL EXISTING ATTRIBUTES", true);
            LinkedHashMultimap reset = LinkedHashMultimap.create();
            meta.setAttributeModifiers((Multimap)reset);
        }
        if (!keepDefaultItemAttributes) {
            SsomarDev.testMsg("REMOVE ALL DEFAULT ATTRIBUTES", true);
            if (!meta.hasAttributeModifiers()) {
                for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                    Multimap invert = itemType.getDefaultAttributeModifiers(equipmentSlot);
                    if (invert.isEmpty()) continue;
                    SsomarDev.testMsg("add blank attribute for EquipmentSlot: " + equipmentSlot, true);
                    for (Attribute col : invert.keySet()) {
                        for (AttributeModifier att : invert.get((Object)col)) {
                            meta.addAttributeModifier(col, new AttributeModifier(att.getUniqueId(), att.getName(), 0.0, att.getOperation(), att.getSlot()));
                        }
                    }
                }
            }
        }
        if (SCore.is1v19Plus() && keepDefaultItemAttributes && (meta.hasAttributeModifiers() || !attributes.isEmpty())) {
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                SsomarDev.testMsg("add default attributes for EquipmentSlot: " + equipmentSlot, true);
                Multimap defaultAttributes = itemType.getDefaultAttributeModifiers(equipmentSlot);
                for (Attribute col : defaultAttributes.keySet()) {
                    for (AttributeModifier att : defaultAttributes.get((Object)col)) {
                        try {
                            meta.addAttributeModifier(col, att);
                        }
                        catch (IllegalArgumentException e) {
                            SsomarDev.testMsg("No add default attribute because already exist: " + col + " " + att, true);
                        }
                    }
                }
            }
        }
        for (Attribute att : attributes.keySet()) {
            AttributeModifier attModifier = attributes.get(att);
            if (mode == AttributeAdditionMode.OVERRIDE || mode == AttributeAdditionMode.STACK) {
                EquipmentSlot slot = attModifier.getSlot();
                ArrayList<AttributeModifier> toRemove = new ArrayList<AttributeModifier>();
                double stackValue = 0.0;
                NamespacedKey stackKey = null;
                Multimap existing = meta.getAttributeModifiers(slot);
                if (existing.containsKey((Object)att)) {
                    for (AttributeModifier modifier : existing.get((Object)att)) {
                        if (!affectDefaultAttributes && modifier.getKey().getKey().contains("base_")) continue;
                        if (mode == AttributeAdditionMode.OVERRIDE) {
                            SsomarDev.testMsg("OVERRIDE ATTRIBUTE: " + modifier, true);
                            toRemove.add(modifier);
                        }
                        if (mode != AttributeAdditionMode.STACK || modifier.getOperation() != attModifier.getOperation() || modifier.getSlotGroup() != attModifier.getSlotGroup()) continue;
                        toRemove.add(modifier);
                        stackValue = modifier.getAmount();
                        stackKey = modifier.getKey();
                        SsomarDev.testMsg("STACK ATTRIBUTE found value: " + modifier.getAmount(), true);
                        break;
                    }
                }
                for (AttributeModifier remove : toRemove) {
                    meta.removeAttributeModifier(att, remove);
                    SsomarDev.testMsg("REMOVE ATTRIBUTE: " + remove, true);
                }
                if (mode == AttributeAdditionMode.STACK) {
                    if (stackKey == null) {
                        stackKey = new NamespacedKey(SCore.pluginHolder, UUID.randomUUID().toString());
                    }
                    double newValue = attModifier.getAmount() + stackValue;
                    SsomarDev.testMsg("STACK ATTRIBUTE new value: " + newValue, true);
                    attModifier = new AttributeModifier(stackKey, newValue, attModifier.getOperation(), attModifier.getSlotGroup());
                }
            }
            meta.addAttributeModifier(att, attModifier);
        }
    }

    public static void removeSpecificAttribute(LivingEntity entity_arg, String attribute_type, String key) {
        LivingEntity entity = entity_arg;
        if (entity_arg instanceof Player) {
            entity = Bukkit.getPlayer((UUID)entity.getUniqueId());
        }
        Attribute attribute = AttributeUtils.getAttribute(attribute_type);
        assert (attribute != null);
        assert (entity != null);
        AttributeInstance attrInstance = entity.getAttribute(attribute);
        assert (attrInstance != null);
        Collection attributeModifiers = attrInstance.getModifiers();
        for (AttributeModifier modifier : attributeModifiers) {
            if (!modifier.getKey().toString().equals(key)) continue;
            attrInstance.removeModifier(modifier);
            return;
        }
    }
}

