/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.placeholders;

import com.ssomar.score.SCore;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.placeholders.PlaceholdersInterface;
import com.ssomar.score.utils.placeholders.PlayerPlaceholdersAbstract;
import java.io.Serializable;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Boat;
import org.bukkit.entity.ChestBoat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.scoreboard.Team;

public class EntityPlaceholdersAbstract
extends PlaceholdersInterface
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String particle;
    private Entity entity;
    private UUID entityUUID;
    private String entityType = "";
    private String entityName = "";
    private double x;
    private double y;
    private double z;
    private String world = "";
    private float pitch;
    private float pitchPositive;
    private float yaw;
    private float yawPositive;
    private double xVelocity;
    private double yVelocity;
    private double zVelocity;
    private String entityDirection;
    private double entityHealth;
    private double entityMaxHealth;
    private double lastDamageTaken;
    private String team;

    public EntityPlaceholdersAbstract(String particle) {
        this.particle = particle;
    }

    public void setEntityPlcHldr(UUID uuid) {
        this.entityUUID = uuid;
        this.reloadEntityPlcHldr();
    }

    public void setEntityPlcHldr(Entity entity) {
        this.entity = entity;
        this.entityUUID = entity.getUniqueId();
        this.reloadEntityPlcHldr();
    }

    public void reloadEntityPlcHldr() {
        if (this.entityUUID == null && this.entity == null) {
            return;
        }
        if (this.entity == null) {
            this.entity = SCore.is1v11Less() ? this.getEntityByUniqueId(this.entityUUID) : Bukkit.getEntity((UUID)this.entityUUID);
        }
        if (this.entity != null) {
            this.entityType = this.entity.getType().toString();
            this.entityName = this.entity.getName();
            Location eLoc = this.entity.getLocation();
            this.x = eLoc.getX();
            this.y = eLoc.getY();
            this.z = eLoc.getZ();
            this.world = eLoc.getWorld().getName();
            this.pitch = eLoc.getPitch();
            if (this.entity instanceof LivingEntity) {
                this.lastDamageTaken = ((LivingEntity)this.entity).getLastDamage();
            }
            this.pitchPositive = this.pitch < 0.0f ? this.pitch * -1.0f : this.pitch;
            this.yaw = eLoc.getYaw();
            this.yawPositive = this.yaw < 0.0f ? this.yaw * -1.0f : this.yaw;
            float yaw = eLoc.getYaw();
            if (yaw >= -30.0f && yaw <= 30.0f) {
                this.entityDirection = "S";
            } else if (yaw > 30.0f && yaw < 60.0f) {
                this.entityDirection = "SW";
            } else if (yaw >= 60.0f && yaw <= 120.0f) {
                this.entityDirection = "W";
            } else if (yaw > 120.0f && yaw < 150.0f) {
                this.entityDirection = "NW";
            } else if (yaw >= 150.0f || yaw <= -150.0f) {
                this.entityDirection = "N";
            } else if (yaw > -150.0f && yaw < -120.0f) {
                this.entityDirection = "NE";
            } else if (yaw >= -120.0f && yaw <= -60.0f) {
                this.entityDirection = "E";
            } else if (yaw > -60.0f && yaw < -30.0f) {
                this.entityDirection = "SE";
            }
            if (this.entity instanceof LivingEntity) {
                LivingEntity lE = (LivingEntity)this.entity;
                this.entityMaxHealth = lE.getMaxHealth();
                this.entityHealth = lE.getHealth();
            } else {
                this.entityMaxHealth = -1.0;
                this.entityHealth = -1.0;
            }
            this.team = "NO_TEAM";
            for (Team t : Bukkit.getServer().getScoreboardManager().getMainScoreboard().getTeams()) {
                if (!t.hasEntry(this.entityUUID.toString())) continue;
                this.team = t.getName();
                break;
            }
        }
    }

    public Entity getEntityByUniqueId(UUID uniqueId) {
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!entity.getUniqueId().equals(uniqueId)) continue;
                return entity;
            }
        }
        return null;
    }

    public String replacePlaceholder(String s) {
        String toReplace = s;
        if (this.entityUUID != null || this.entity != null) {
            toReplace = toReplace.replaceAll("\\%" + this.particle + "\\%", this.entityType);
            toReplace = toReplace.replaceAll("\\%" + this.particle + "_lower_case" + "\\%", this.entityType.toLowerCase());
            toReplace = toReplace.replaceAll("\\%" + this.particle + "_name" + "\\%", this.entityName);
            toReplace = toReplace.replaceAll("\\%" + this.particle + "_name_lower_case" + "\\%", this.entityName.toLowerCase());
            toReplace = toReplace.replaceAll("\\%" + this.particle + "_uuid" + "\\%", this.entityUUID.toString());
            toReplace = toReplace.replaceAll("\\%" + this.particle + "_uuid_array" + "\\%", PlayerPlaceholdersAbstract.convertedUUID(this.entityUUID));
            try {
                EntitySnapshot entitySnapshot = this.entity.createSnapshot();
                if (entitySnapshot != null) {
                    toReplace = toReplace.replaceAll("\\%" + this.particle + "_serialized" + "\\%", entitySnapshot.getAsString());
                }
            }
            catch (Error | Exception entitySnapshot) {
                // empty catch block
            }
            if (this.entity != null && this.entity instanceof Item) {
                Item item = (Item)this.entity;
                toReplace = toReplace.replaceAll("%" + this.particle + "_item%", item.getItemStack().getType().toString());
            } else if (this.entity != null && SCore.is1v19Plus() && (this.entity instanceof ChestBoat || this.entity instanceof Boat)) {
                Boat boat = (Boat)this.entity;
                toReplace = toReplace.replaceAll("%" + this.particle + "_item%", boat.getBoatType().toString() + "_" + this.entity.getType());
            }
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_last_damage_taken%", this.lastDamageTaken + "", false);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_last_damage_taken_int%", (int)this.lastDamageTaken + "", true);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_x%", NTools.reduceDouble(this.x, 2) + "", false);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_y%", NTools.reduceDouble(this.y, 2) + "", false);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_z%", NTools.reduceDouble(this.z, 2) + "", false);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_x_int%", (int)this.x + "", true);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_y_int%", (int)this.y + "", true);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_z_int%", (int)this.z + "", true);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_x_velocity%", this.xVelocity + "", false);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_y_velocity%", this.yVelocity + "", false);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_z_velocity%", this.zVelocity + "", false);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_x_velocity_int%", (int)this.xVelocity + "", true);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_y_velocity_int%", (int)this.yVelocity + "", true);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_z_velocity_int%", (int)this.zVelocity + "", true);
            toReplace = toReplace.replaceAll("%" + this.particle + "_world%", this.world);
            toReplace = toReplace.replaceAll("%" + this.particle + "_world_lower%", this.world.toLowerCase());
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_pitch%", this.pitch + "", false);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_pitch_int%", (int)this.pitch + "", true);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_pitch_positive%", this.pitchPositive + "", false);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_pitch_positive_int%", (int)this.pitchPositive + "", false);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_yaw%", this.yaw + "", false);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_yaw_int%", (int)this.yaw + "", true);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_yaw_positive%", this.yawPositive + "", false);
            toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_yaw_positive_int%", (int)this.yawPositive + "", false);
            toReplace = toReplace.replaceAll("%" + this.particle + "_direction%", this.entityDirection);
            if (this.entityMaxHealth != -1.0) {
                toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_max_health%", this.entityMaxHealth + "", false);
            }
            if (this.entityHealth != -1.0) {
                toReplace = EntityPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_health%", this.entityHealth + "", false);
            }
            toReplace = toReplace.replaceAll("%" + this.particle + "_team%", this.team);
        }
        return toReplace;
    }
}

