/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.strings;

import com.ssomar.score.utils.strings.StringSimplifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class StringJoiner {
    public static <T> String join(T[] array, String delimiter) {
        return StringJoiner.join(array, delimiter, (T object) -> Optional.ofNullable(object).map(StringSimplifier::simplify).orElse(""));
    }

    public static <T> String join(Iterable<T> iterable, String delimiter) {
        return StringJoiner.join(iterable, delimiter, (T object) -> Optional.ofNullable(object).map(StringSimplifier::simplify).orElse(""));
    }

    public static <T> String join(@NotNull T[] array, Stringer<T> stringer) {
        return StringJoiner.join(array, ", ", stringer);
    }

    public static <T> String join(@NotNull T[] array, String delimiter, Stringer<T> stringer) {
        return StringJoiner.join(Arrays.asList(array), delimiter, stringer);
    }

    public static <T> String join(Iterable<T> iterable, Stringer<T> stringer) {
        return StringJoiner.join(iterable, ", ", stringer);
    }

    public static <T> String join(Iterable<T> iterable, String delimiter, Stringer<T> stringer) {
        Iterator<T> iterator = iterable.iterator();
        StringBuilder message = new StringBuilder();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (t == null) continue;
            message.append(stringer.toString(t)).append(iterator.hasNext() ? delimiter : "");
        }
        return message.toString();
    }

    @Generated
    private StringJoiner() {
    }

    public static interface Stringer<T> {
        public String toString(T var1);
    }
}

