/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.CommandsHandler;
import com.ssomar.score.commands.runnable.RunCommand;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommandManager;
import com.ssomar.score.commands.runnable.block.BlockSCommand;
import com.ssomar.score.usedapi.AllWorldManager;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class BlockRunCommand
extends RunCommand {
    private static final long serialVersionUID = 1L;
    private UUID launcherUUID;
    private int blockX;
    private int blockY;
    private int blockZ;
    private UUID blockWorld;
    private Material oldBlockMaterial;
    private boolean silenceOutput;

    public BlockRunCommand(String brutCommand, int delay, ActionInfo aInfo) {
        super(brutCommand, delay, aInfo);
    }

    public BlockRunCommand(String brutCommand, long runTime, ActionInfo aInfo) {
        super(brutCommand, runTime, aInfo);
    }

    @Override
    public void pickupInfo() {
        ActionInfo aInfo = this.getaInfo();
        this.launcherUUID = aInfo.getLauncherUUID();
        this.blockX = aInfo.getBlockLocationX();
        this.blockY = aInfo.getBlockLocationY();
        this.blockZ = aInfo.getBlockLocationZ();
        this.blockWorld = aInfo.getBlockLocationWorld();
        this.oldBlockMaterial = Material.valueOf((String)aInfo.getOldBlockMaterialName());
        this.silenceOutput = aInfo.isSilenceOutput();
    }

    @Override
    public void runGetManager() {
        this.runCommand(BlockCommandManager.getInstance());
    }

    @Override
    public void runCommand(SCommandToExec sCommandToExec) {
        Optional<World> worldOptional;
        BlockSCommand bCommand = (BlockSCommand)((Object)sCommandToExec.getSCommand());
        Player launcher = null;
        if (this.launcherUUID != null) {
            launcher = Bukkit.getPlayer((UUID)this.launcherUUID);
        }
        if (!(worldOptional = AllWorldManager.getWorld(this.blockWorld)).isPresent()) {
            return;
        }
        Location loc = new Location(worldOptional.get(), (double)this.blockX, (double)this.blockY, (double)this.blockZ);
        Block block = loc.getBlock();
        ActionInfo aInfo = this.getaInfo();
        aInfo.setOldBlockMaterial(this.oldBlockMaterial);
        sCommandToExec.setActionInfo(aInfo);
        bCommand.run(launcher, block, sCommandToExec);
    }

    @Override
    public void insideDelayedCommand() {
        this.runCommand(BlockCommandManager.getInstance());
        CommandsHandler.getInstance().removeDelayedCommand(this.getUuid(), null, false);
    }

    @Override
    public void executeRunnable(Runnable runnable) {
        Optional<World> worldOptional = AllWorldManager.getWorld(this.blockWorld);
        if (!worldOptional.isPresent()) {
            return;
        }
        Location loc = new Location(worldOptional.get(), (double)this.blockX, (double)this.blockY, (double)this.blockZ);
        SCore.schedulerHook.runLocationTaskAsap(runnable, loc);
    }

    public UUID getLauncherUUID() {
        return this.launcherUUID;
    }

    public void setLauncherUUID(UUID launcherUUID) {
        this.launcherUUID = launcherUUID;
    }

    public int getBlockX() {
        return this.blockX;
    }

    public void setBlockX(int blockX) {
        this.blockX = blockX;
    }

    public int getBlockY() {
        return this.blockY;
    }

    public void setBlockY(int blockY) {
        this.blockY = blockY;
    }

    public int getBlockZ() {
        return this.blockZ;
    }

    public void setBlockZ(int blockZ) {
        this.blockZ = blockZ;
    }

    public UUID getBlockWorld() {
        return this.blockWorld;
    }

    public void setBlockWorld(UUID blockWorld) {
        this.blockWorld = blockWorld;
    }

    public Material getOldBlockMaterial() {
        return this.oldBlockMaterial;
    }

    public void setOldBlockMaterial(Material oldBlockMaterial) {
        this.oldBlockMaterial = oldBlockMaterial;
    }

    public boolean isSilenceOutput() {
        return this.silenceOutput;
    }

    public void setSilenceOutput(boolean silenceOutput) {
        this.silenceOutput = silenceOutput;
    }
}

