/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.particles.commands.XParticle;
import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.CommmandThatRunsCommand;
import com.ssomar.score.commands.runnable.SCommand;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import com.ssomar.score.configs.messages.Message;
import com.ssomar.score.configs.messages.MessageMain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class Around
extends MixedCommand {
    private static final Boolean DEBUG = false;

    public Around() {
        CommandSetting distance = new CommandSetting("distance", 0, Double.class, (Object)3.0);
        CommandSetting displayMsgIfNoPlayer = new CommandSetting("displayMsgIfNoPlayer", 1, Boolean.class, (Object)true, true);
        CommandSetting throughBlocks = new CommandSetting("throughBlocks", -1, Boolean.class, (Object)true);
        CommandSetting safeDistance = new CommandSetting("safeDistance", -1, Double.class, (Object)0.0);
        CommandSetting offsetYaw = new CommandSetting("offsetYaw", -1, Double.class, (Object)0.0);
        CommandSetting offsetPitch = new CommandSetting("offsetPitch", -1, Double.class, (Object)0.0);
        CommandSetting offsetDistance = new CommandSetting("offsetDistance", -1, Double.class, (Object)0.0);
        CommandSetting limit = new CommandSetting("limit", -1, Integer.class, (Object)-1);
        CommandSetting sort = new CommandSetting("sort", -1, String.class, (Object)"NEAREST");
        List<CommandSetting> settings = this.getSettings();
        settings.add(distance);
        settings.add(displayMsgIfNoPlayer);
        settings.add(throughBlocks);
        settings.add(safeDistance);
        settings.add(offsetYaw);
        settings.add(offsetPitch);
        settings.add(offsetDistance);
        settings.add(limit);
        settings.add(sort);
        this.setNewSettingsMode(true);
        this.setCanExecuteCommands(true);
    }

    public static void aroundExecution(final Entity receiver, final SCommandToExec sCommandToExec, final boolean displayMsgIfNoTargetHit) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean hit;
                double distance = (Double)sCommandToExec.getSettingValue("distance");
                boolean throughBlocks = (Boolean)sCommandToExec.getSettingValue("throughBlocks");
                double safeDistance = (Double)sCommandToExec.getSettingValue("safeDistance");
                double offsetYaw = (Double)sCommandToExec.getSettingValue("offsetYaw");
                double offsetPitch = (Double)sCommandToExec.getSettingValue("offsetPitch");
                double offsetDistance = (Double)sCommandToExec.getSettingValue("offsetDistance");
                int limit = (Integer)sCommandToExec.getSettingValue("limit");
                String sort = (String)sCommandToExec.getSettingValue("sort");
                Vector offset = XParticle.calculDirection(offsetYaw, offsetPitch).multiply(offsetDistance);
                Location loc = receiver.getLocation().add(offset);
                List<Player> targets = new ArrayList();
                for (Entity e : loc.getNearbyEntities(distance, distance, distance)) {
                    Location targetLoc;
                    if (!(e instanceof Player)) continue;
                    Player target = (Player)e;
                    if (safeDistance > 0.0 && loc.distance(targetLoc = target.getLocation()) <= safeDistance) continue;
                    if (!throughBlocks) {
                        Location receiverLoc = receiver.getLocation();
                        if (receiver instanceof LivingEntity) {
                            receiverLoc = ((LivingEntity)receiver).getEyeLocation();
                        }
                        ArrayList<Location> toCheck = new ArrayList<Location>();
                        toCheck.add(target.getLocation());
                        toCheck.add(target.getEyeLocation());
                        toCheck.add(target.getLocation().add(0.0, 1.0, 0.0));
                        boolean valid = false;
                        for (Location l : toCheck) {
                            double distanceBetween = receiverLoc.distance(l);
                            Vector direction = l.toVector().subtract(receiverLoc.toVector()).normalize();
                            RayTraceResult rayTraceResult = receiver.getWorld().rayTraceBlocks(receiverLoc, direction, distanceBetween, FluidCollisionMode.NEVER, true);
                            if (rayTraceResult != null) continue;
                            valid = true;
                            break;
                        }
                        if (!valid) continue;
                    }
                    if (target.hasMetadata("NPC") || target.equals((Object)receiver)) continue;
                    targets.add(target);
                }
                if (sort.equalsIgnoreCase("NEAREST")) {
                    targets.sort((p1, p2) -> {
                        double d1 = p1.getLocation().distance(loc);
                        double d2 = p2.getLocation().distance(loc);
                        return Double.compare(d1, d2);
                    });
                } else if (sort.equalsIgnoreCase("RANDOM")) {
                    Collections.shuffle(targets);
                }
                if (limit > 0 && targets.size() > limit) {
                    targets = targets.subList(0, limit);
                }
                if (!(hit = CommmandThatRunsCommand.runPlayerCommands(targets, sCommandToExec.getOtherArgs(), sCommandToExec.getActionInfo())) && displayMsgIfNoTargetHit && receiver instanceof Player) {
                    SCommand.sm.sendMessage((CommandSender)receiver, MessageMain.getInstance().getMessage((Plugin)SCore.plugin, Message.NO_PLAYER_HIT));
                }
            }
        };
        SCore.schedulerHook.runLocationTask(runnable, receiver.getLocation(), 0L);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        Around.aroundExecution((Entity)receiver, sCommandToExec, (Boolean)sCommandToExec.getSettingValue("displayMsgIfNoPlayer"));
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("AROUND");
        return names;
    }

    @Override
    public String getTemplate() {
        return "AROUND distance:3.0 displayMsgIfNoPlayer:true throughBlocks:true safeDistance:0.0 {Your commands here}";
    }

    @Override
    public ChatColor getColor() {
        return ChatColor.LIGHT_PURPLE;
    }

    @Override
    public ChatColor getExtraColor() {
        return ChatColor.DARK_PURPLE;
    }

    @Override
    public void run(Player p, Entity entity, SCommandToExec sCommandToExec) {
        Around.aroundExecution(entity, sCommandToExec, false);
    }
}

