/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.score;

import com.ssomar.executableitems.configs.Message;
import com.ssomar.score.api.executableitems.events.AddItemInPlayerInventoryEvent;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.CommandsHandler;
import com.ssomar.score.commands.runnable.player.PlayerRunCommand;
import com.ssomar.score.commands.score.CustomCommandWithManagerAbstract;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectBuildable;
import com.ssomar.score.sobject.SObjectManager;
import com.ssomar.score.sobject.manager.ManagerWithBuildable;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import com.ssomar.score.utils.strings.StringSetting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class GiveCommand<X extends SPlugin, Y extends SObjectManager<Z>, Z extends SObject>
extends CustomCommandWithManagerAbstract<X, Y, Z> {
    public GiveCommand(X sPlugin, Y sObjectManager) {
        super(sPlugin, sObjectManager);
    }

    public void give(CommandSender sender, String objectId, String amount, String player, Map<String, Object> settings, String world, boolean giveOfflinePlayer, String commandToRunIfPlayerIsOffline) {
        Optional objectOpt = this.checkSObject(sender, objectId);
        if (!objectOpt.isPresent()) {
            return;
        }
        Optional<Integer> amountOpt = this.checkAmount(sender, amount);
        if (!amountOpt.isPresent()) {
            return;
        }
        Optional<Optional<Player>> playerOpt = this.checkPlayer(sender, player, giveOfflinePlayer);
        Optional<Optional<World>> worldOpt = this.checkWorld(sender, world);
        if (!worldOpt.isPresent()) {
            return;
        }
        if (!playerOpt.isPresent()) {
            GiveCommand.runOfflineCommand(player, giveOfflinePlayer, commandToRunIfPlayerIsOffline);
            return;
        }
        this.give(playerOpt.get(), (SObject)objectOpt.get(), amountOpt.get(), settings, worldOpt.get());
        if (!this.getSPlugin().getPluginConfig().getBooleanSetting("silentGive")) {
            this.getSm().sendMessage(sender, this.getSPlugin().getNameDesign() + " &a" + ((SObjectManager)this.getSObjectManager()).getObjectName() + " &e" + objectId + " &agiven to &e" + player + " &a(&7" + amount + "&a)");
        }
    }

    public static void runOfflineCommand(String player, boolean giveOfflinePlayer, String commandToRunIfPlayerIsOffline) {
        OfflinePlayer p = Bukkit.getOfflinePlayer((String)player);
        if (giveOfflinePlayer) {
            ActionInfo aInfo = new ActionInfo("", new StringPlaceholder());
            aInfo.setReceiverUUID(p.getUniqueId());
            PlayerRunCommand command = new PlayerRunCommand(commandToRunIfPlayerIsOffline, 0, aInfo);
            CommandsHandler handler = CommandsHandler.getInstance();
            if (handler.getDelayedCommandsSaved().containsKey(p.getUniqueId())) {
                handler.getDelayedCommandsSaved().get(p.getUniqueId()).add(command);
            } else {
                handler.getDelayedCommandsSaved().put(p.getUniqueId(), new ArrayList<PlayerRunCommand>(Arrays.asList(command)));
            }
        }
    }

    public void give(Optional<Player> playerOpt, Z object, int amount, Map<String, Object> settings, Optional<World> worldOpt) {
        if (playerOpt.isPresent()) {
            this.multipleGive(playerOpt.get(), object, amount, settings);
        } else {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (worldOpt.isPresent()) {
                    if (!p.getWorld().equals((Object)worldOpt.get())) continue;
                    this.multipleGive(p, object, amount, settings);
                    continue;
                }
                this.multipleGive(p, object, amount, settings);
            }
        }
    }

    public void giveSlot(CommandSender sender, String executableItem, String amount, String player, Map<String, Object> settings, String slot, String overrideStr, boolean giveOfflinePlayer, String commandToRunIfPlayerIsOffline) {
        Optional objectOpt = this.checkSObject(sender, executableItem);
        if (!objectOpt.isPresent()) {
            return;
        }
        Optional<Integer> amountOpt = this.checkAmount(sender, amount);
        if (!amountOpt.isPresent()) {
            return;
        }
        Optional<Integer> slotOpt = this.checkSlot(sender, slot);
        if (!slotOpt.isPresent()) {
            return;
        }
        Optional<Optional<Player>> playerOpt = this.checkPlayer(sender, player, giveOfflinePlayer);
        boolean override = Boolean.parseBoolean(overrideStr);
        if (!playerOpt.isPresent()) {
            GiveCommand.runOfflineCommand(player, giveOfflinePlayer, commandToRunIfPlayerIsOffline);
            return;
        }
        if (playerOpt.get().isPresent()) {
            Player p = playerOpt.get().get();
            PlayerInventory inventory = p.getInventory();
            boolean callAddInInventoryEvent = false;
            if (inventory.getItem(slotOpt.get().intValue()) == null) {
                inventory.setItem(slotOpt.get().intValue(), ((SObjectBuildable)((Object)((SObject)objectOpt.get()))).buildItem(amountOpt.get(), playerOpt.get(), settings));
                callAddInInventoryEvent = true;
            } else {
                ItemStack item = inventory.getItem(slotOpt.get().intValue()).clone();
                ItemStack toCompare = item.clone();
                toCompare.setAmount(1);
                if (toCompare.isSimilar(((SObjectBuildable)((Object)((SObject)objectOpt.get()))).buildItem(1, playerOpt.get(), settings)) && ((SObjectBuildable)((Object)((SObject)objectOpt.get()))).canBeStacked()) {
                    inventory.getItem(slotOpt.get().intValue()).setAmount(inventory.getItem(slotOpt.get().intValue()).getAmount() + amountOpt.get());
                    callAddInInventoryEvent = true;
                } else if (override) {
                    inventory.setItem(slotOpt.get().intValue(), ((SObjectBuildable)((Object)((SObject)objectOpt.get()))).buildItem(amountOpt.get(), playerOpt.get(), settings));
                    callAddInInventoryEvent = true;
                    for (ItemStack toDrop : inventory.addItem(new ItemStack[]{item}).values()) {
                        p.getWorld().dropItem(p.getLocation(), toDrop);
                    }
                }
            }
            if (callAddInInventoryEvent && this.getSPlugin().getShortName().equals("EI")) {
                AddItemInPlayerInventoryEvent eventToCall = new AddItemInPlayerInventoryEvent(p, inventory.getItem(slotOpt.get().intValue()), slotOpt.get());
                Bukkit.getPluginManager().callEvent((Event)eventToCall);
            }
            if (!this.getSPlugin().getPluginConfig().getBooleanSetting("silentGive")) {
                this.getSm().sendMessage(sender, this.getSPlugin().getNameDesign() + " &a" + ((SObjectManager)this.getSObjectManager()).getObjectName() + " &e" + executableItem + " &agiven to &e" + player + " &a(&7" + amount + "&a) &ain slot &e" + slot);
            }
        }
    }

    public int give(Player player, Z sObject, Map<String, Object> settings, int quantity) {
        Optional<Player> pOptional = Optional.ofNullable(player);
        int firstEmptySlot = player.getInventory().firstEmpty();
        ItemStack itemStack = ((SObjectBuildable)sObject).buildItem(quantity, pOptional, settings);
        HashMap over = player.getInventory().addItem(new ItemStack[]{itemStack});
        if (over.size() > 0) {
            int out = 0;
            for (Integer index : over.keySet()) {
                player.getWorld().dropItem(player.getLocation(), (ItemStack)over.get(index));
                out += ((ItemStack)over.get(index)).getAmount();
            }
            return out;
        }
        if (this.getSPlugin().getShortName().equals("EI")) {
            AddItemInPlayerInventoryEvent eventToCall = new AddItemInPlayerInventoryEvent(player, itemStack, firstEmptySlot);
            Bukkit.getPluginManager().callEvent((Event)eventToCall);
        }
        return 0;
    }

    public int simpleGive(Player player, Z sObject, Map<String, Object> settings) {
        return this.give(player, sObject, settings, 1);
    }

    public void multipleGive(Player player, Z object, int quantity, Map<String, Object> settings) {
        int notAbbleToGive;
        Optional<Player> pOptional = Optional.ofNullable(player);
        int limit = this.getSPlugin().getPluginConfig().getIntSetting("pickupLimit", 100000);
        if (limit <= -1) {
            limit = 100000;
        }
        int cpt = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !(this.getSObjectManager() instanceof ManagerWithBuildable) || !((ManagerWithBuildable)this.getSObjectManager()).getObject(item).isPresent()) continue;
            cpt += item.getAmount();
        }
        int quantityAbleToGive = limit - cpt;
        if (quantityAbleToGive < 0) {
            quantityAbleToGive = 0;
        }
        if ((notAbbleToGive = quantity - quantityAbleToGive) < 0) {
            notAbbleToGive = 0;
        }
        ItemStack item = ((SObjectBuildable)object).buildItem(1, pOptional, settings);
        int maxStack = item.getMaxStackSize();
        int inInventory = quantity -= notAbbleToGive;
        int outInventory = 0;
        while (quantity > 0) {
            outInventory += this.give(player, object, settings, Math.min(maxStack, quantity));
            quantity -= maxStack;
        }
        if (outInventory > 0) {
            this.getSm().sendMessage(player, StringConverter.replaceVariable(MessageMain.getInstance().getMessage(this.getSPlugin().getPlugin(), (MessageInterface)Message.FULL_INVENTORY), player.getName(), ((SObjectBuildable)object).getItemName(), outInventory + "", 0));
            inInventory -= outInventory;
        }
        while (notAbbleToGive > 0) {
            player.getWorld().dropItem(player.getLocation(), ((SObjectBuildable)object).buildItem(Math.min(maxStack, quantity), pOptional, settings));
            notAbbleToGive -= maxStack;
            this.getSm().sendMessage(player, StringConverter.coloredString(MessageMain.getInstance().getMessage(this.getSPlugin().getPlugin(), (MessageInterface)Message.PICKUP_LIMIT_MESSAGE)).replaceAll("%limit%", "" + this.getSPlugin().getPluginConfig().getIntSetting("pickupLimit", 100000)));
        }
        if (!this.getSPlugin().getPluginConfig().getBooleanSetting("silentGive")) {
            this.getSm().sendMessage(player, StringConverter.replaceVariable(MessageMain.getInstance().getMessage(this.getSPlugin().getPlugin(), (MessageInterface)Message.RECEIVE_ITEM), player.getName(), ((SObjectBuildable)object).getItemName(), inInventory + "", 0));
        }
    }

    @Override
    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("give");
        commands.add("giveall");
        commands.add("giveslot");
        return commands;
    }

    @Override
    public void run(CommandSender sender, String command, String[] args, String typedCommand) {
        switch (command) {
            case "give": {
                if (args.length >= 2) {
                    ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
                    Map<String, Object> settings = StringSetting.extractSettingsAndRebuildCorrectly(arguments, 1, new ArrayList<String>());
                    Map variablesMap = GiveCommand.checkVariables(sender, typedCommand).orElse(new HashMap());
                    if (!variablesMap.isEmpty()) {
                        settings.put("Variables", variablesMap);
                        this.getSm().sendMessage(sender, "&cWARNING : &6VAR() &cin the command &6/" + this.getSPlugin().getShortName().toLowerCase() + " give &cis deprecated, please use the new method to set variables in the command /ei give Ssomar &6xyz{Variables:{test:5,test2:\"Edit please\"}}");
                        this.getSm().sendMessage(sender, "&cCommand : &7" + typedCommand);
                        this.getSm().sendMessage(sender, "&cThis method will be removed during June 2024");
                    }
                    Optional<Integer> usage = GiveCommand.checkUsage(sender, typedCommand).orElse(Optional.empty());
                    usage.ifPresent(integer -> {
                        settings.put("Usage", String.valueOf(integer));
                        this.getSm().sendMessage(sender, "&cWARNING : &6USAGE() &cin the command &6/" + this.getSPlugin().getShortName().toLowerCase() + " give &cis deprecated, please use the new method to set usage in the command /ei give Ssomar &6xyz{Usage:5}");
                        this.getSm().sendMessage(sender, "&cCommand : &7" + typedCommand);
                        this.getSm().sendMessage(sender, "&cThis method will be removed during June 2024");
                    });
                    String pName = (String)arguments.get(0);
                    String eiID = (String)arguments.get(1);
                    String quantity = "1";
                    if (arguments.size() >= 3) {
                        quantity = (String)arguments.get(2);
                    }
                    boolean giveOfflinePlayer = true;
                    if (arguments.size() >= 4) {
                        giveOfflinePlayer = Boolean.parseBoolean((String)arguments.get(3));
                    }
                    new GiveCommand(this.getSPlugin(), this.getSObjectManager()).give(sender, eiID, quantity, pName, settings, "", giveOfflinePlayer, typedCommand);
                    break;
                }
                this.getSm().sendMessage(sender, ChatColor.RED + this.getSPlugin().getNameWithBrackets() + " &cNot enough args /" + this.getSPlugin().getShortName().toLowerCase() + " give {playername} {id} {quantity} [giveOfflinePlayer]");
                break;
            }
            case "giveall": {
                if (args.length >= 1) {
                    ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
                    Map<String, Object> settings = StringSetting.extractSettingsAndRebuildCorrectly(arguments, 1, new ArrayList<String>());
                    String eiID = (String)arguments.get(0);
                    String quantity = "1";
                    String world = "";
                    if (arguments.size() >= 2) {
                        quantity = (String)arguments.get(1);
                    }
                    boolean giveOfflinePlayer = false;
                    if (arguments.size() >= 3) {
                        String arg = (String)arguments.get(2);
                        if (arg.equalsIgnoreCase("true") || arg.equalsIgnoreCase("false")) {
                            giveOfflinePlayer = Boolean.parseBoolean(arg);
                        } else {
                            world = (String)arguments.get(2);
                        }
                    }
                    if (arguments.size() >= 4) {
                        giveOfflinePlayer = Boolean.parseBoolean((String)arguments.get(3));
                    }
                    new GiveCommand(this.getSPlugin(), this.getSObjectManager()).give(sender, eiID, quantity, "all", settings, world, giveOfflinePlayer, typedCommand);
                    break;
                }
                this.getSm().sendMessage(sender, ChatColor.RED + this.getSPlugin().getNameWithBrackets() + " &cNot enough argument /" + this.getSPlugin().getShortName().toLowerCase() + " giveall {id} {quantity} [world] [giveOfflinePlayer]");
                break;
            }
            case "giveslot": {
                ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
                Map<String, Object> settings = StringSetting.extractSettingsAndRebuildCorrectly(arguments, 1, new ArrayList<String>());
                if (arguments.size() < 4) {
                    this.getSm().sendMessage(sender, ChatColor.RED + this.getSPlugin().getNameWithBrackets() + " &cError not enought argument /" + this.getSPlugin().getShortName().toLowerCase() + " giveslot {player} {id} {quantity} {slot} [override] [giveOfflinePlayer]");
                    break;
                }
                String override = "false";
                if (arguments.size() >= 5) {
                    override = (String)arguments.get(4);
                }
                boolean giveOfflinePlayer = true;
                if (arguments.size() >= 6) {
                    giveOfflinePlayer = Boolean.parseBoolean((String)arguments.get(5));
                }
                new GiveCommand(this.getSPlugin(), this.getSObjectManager()).giveSlot(sender, (String)arguments.get(1), (String)arguments.get(2), (String)arguments.get(0), settings, (String)arguments.get(3), override, giveOfflinePlayer, typedCommand);
            }
        }
    }

    @Override
    public List<String> getArguments(String command, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        switch (args[0]) {
            case "giveall": {
                for (SObject item : ((SObjectManager)this.getSObjectManager()).getLoadedObjects()) {
                    arguments.add(item.getId());
                }
                Collections.sort(arguments);
                return arguments;
            }
            case "give": {
                if (args.length == 3) {
                    return ((SObjectManager)this.getSObjectManager()).getLoadedObjectsWith(args[2]);
                }
                if (args.length != 4) break;
                arguments.add("0");
                arguments.add("1");
                arguments.add("3");
                arguments.add("5");
                arguments.add("10");
                arguments.add("25");
                arguments.add("50");
                return arguments;
            }
            case "giveslot": {
                if (args.length == 3) {
                    return ((SObjectManager)this.getSObjectManager()).getLoadedObjectsWith(args[2]);
                }
                if (args.length == 4) {
                    arguments.add("0");
                    arguments.add("1");
                    arguments.add("3");
                    arguments.add("5");
                    arguments.add("10");
                    arguments.add("25");
                    arguments.add("50");
                    return arguments;
                }
                if (args.length != 5) break;
                arguments.add("0");
                arguments.add("1");
                arguments.add("2");
                arguments.add("3");
                arguments.add("4");
                arguments.add("5");
                arguments.add("6");
                arguments.add("7");
                arguments.add("8");
                return arguments;
            }
        }
        return arguments;
    }

    @Override
    public Optional<Integer> checkAmount(CommandSender sender, String amount) {
        if (!NTools.getInteger(amount).isPresent()) {
            this.getSm().sendMessage(sender, ChatColor.RED + this.getSPlugin().getNameWithBrackets() + " Invalid amount : " + amount);
            return Optional.empty();
        }
        if (NTools.getInteger(amount).get() > this.getSPlugin().getPluginConfig().getIntSetting("giveLimit", 100)) {
            this.getSm().sendMessage(sender, ChatColor.RED + this.getSPlugin().getNameWithBrackets() + " Quantity > " + this.getSPlugin().getPluginConfig().getIntSetting("giveLimit", 100) + " is blocked for security !");
            return Optional.empty();
        }
        return NTools.getInteger(amount);
    }

    public static Optional<Map<String, String>> checkVariables(CommandSender sender, String variables) {
        String[] split2;
        String[] split;
        if (variables == null || variables.isEmpty()) {
            return Optional.empty();
        }
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        if (variables.contains("VAR(") && (split = variables.split("VAR\\(")).length > 1 && (split2 = split[1].split("\\)")).length > 0) {
            String[] split3;
            String allVariables = split2[0].trim();
            for (String s : split3 = allVariables.split(",")) {
                String value;
                String key;
                String[] split4 = s.split(":");
                if (split4.length > 1) {
                    key = split4[0].trim();
                    value = split4[1].trim();
                    if (key.isEmpty() || value.isEmpty()) {
                        return Optional.empty();
                    }
                } else {
                    return Optional.empty();
                }
                variablesMap.put(key, value);
            }
            return Optional.of(variablesMap);
        }
        return Optional.of(new HashMap());
    }

    public static Optional<Optional<Integer>> checkUsage(CommandSender sender, String usage) {
        String[] split2;
        String[] split;
        if (usage == null || usage.isEmpty()) {
            return Optional.empty();
        }
        if (NTools.getInteger(usage).isPresent()) {
            return Optional.of(NTools.getInteger(usage));
        }
        if (usage.contains("USAGE(") && (split = usage.split("USAGE\\(")).length > 1 && (split2 = split[1].split("\\)")).length > 0) {
            String usage2 = split2[0].trim();
            if (NTools.getInteger(usage2).isPresent()) {
                return Optional.of(NTools.getInteger(usage2));
            }
            return Optional.empty();
        }
        return Optional.of(Optional.empty());
    }
}

