/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.data;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.data.BlockCommandsQuery;
import com.ssomar.score.data.CommandsQuery;
import com.ssomar.score.data.CooldownsQuery;
import com.ssomar.score.data.Database1v18;
import com.ssomar.score.data.DatabaseOld;
import com.ssomar.score.data.EntityCommandsQuery;
import com.ssomar.score.data.PlayerCommandsQuery;
import com.ssomar.score.data.SecurityOPQuery;
import com.ssomar.score.data.UsePerDayQuery;
import com.ssomar.score.data.VariablesQuery;
import com.ssomar.score.utils.logging.Utils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class Database {
    private static Database instance;
    private static Connection conn;
    public static boolean useMySQL;
    public static boolean DEBUG;
    private String fileName;

    public static Database getInstance() {
        if (instance == null) {
            instance = new Database();
        }
        return instance;
    }

    public void load() {
        this.fileName = "data.db";
        if (!GeneralConfig.getInstance().isUseMySQL()) {
            this.createNewDatabase();
        }
        SecurityOPQuery.createNewTable(this.connect());
        CommandsQuery.createNewTable(this.connect());
        CooldownsQuery.createNewTable(this.connect());
        PlayerCommandsQuery.createNewTable(this.connect());
        EntityCommandsQuery.createNewTable(this.connect());
        BlockCommandsQuery.createNewTable(this.connect());
        UsePerDayQuery.createNewTable(this.connect());
        if (GeneralConfig.getInstance().isUseMySQL()) {
            VariablesQuery.createNewTable(this.connect());
        }
    }

    public void createNewDatabase() {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        String url = "jdbc:sqlite:" + SCore.dataFolder + "/" + this.fileName;
        try (Connection conn = this.connect();){
            if (conn != null) {
                Utils.sendConsoleMsg("&eSCore &7Connection to the db...");
            }
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    public Connection connect() {
        return this.connect(false);
    }

    public Connection connect(boolean forceReopen) {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        String urlLocal = "jdbc:sqlite:" + SCore.dataFolder + "/" + this.fileName;
        boolean needOpenConnection = true;
        try {
            if (conn != null && !conn.isClosed()) {
                try {
                    needOpenConnection = !conn.isValid(2);
                }
                catch (AbstractMethodError e) {
                    needOpenConnection = false;
                }
            }
        }
        catch (SQLException e) {
            needOpenConnection = true;
        }
        if (conn != null && forceReopen) {
            try {
                conn.close();
                if (DEBUG) {
                    Utils.sendConsoleMsg("Connection closed");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            needOpenConnection = true;
        }
        if (needOpenConnection) {
            useMySQL = false;
            try {
                String where;
                String string = where = GeneralConfig.getInstance().isUseMySQL() ? "MySQL" : "In Local";
                if (!forceReopen) {
                    Utils.sendConsoleMsg("&eSCore &7will connect to the database hosted: &6" + where);
                }
                if (GeneralConfig.getInstance().isUseMySQL()) {
                    try {
                        conn = SCore.is1v17Plus() ? new Database1v18().get1v18Connection() : new DatabaseOld().getOldConnection();
                        useMySQL = true;
                    }
                    catch (SQLException e) {
                        Utils.sendConsoleMsg("&eSCore &cError when trying to connect to the database " + e.getMessage());
                        conn = DriverManager.getConnection(urlLocal);
                    }
                    catch (NoClassDefFoundError e) {
                        Utils.sendConsoleMsg("&eSCore &cError the library to connect to mysql is not present on your server (local db used instead) " + e.getMessage());
                        conn = DriverManager.getConnection(urlLocal);
                    }
                } else {
                    conn = DriverManager.getConnection(urlLocal);
                }
            }
            catch (SQLException e) {
                Utils.sendConsoleMsg("&eSCore &cError when trying to connect to the database " + e.getMessage());
            }
        }
        return conn;
    }

    static {
        useMySQL = false;
        DEBUG = false;
    }
}

