/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.cooldowns;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.data.CooldownsQuery;
import com.ssomar.score.data.Database;
import com.ssomar.score.features.custom.cooldowns.Cooldown;
import com.ssomar.score.features.custom.cooldowns.CooldownsManager;
import com.ssomar.score.utils.logging.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class CooldownsHandler
implements Listener {
    public static void loadCooldowns() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                List<Cooldown> cooldowns = CooldownsQuery.getGlobalCooldowns(Database.getInstance().connect());
                CooldownsManager.getInstance().addCooldowns(cooldowns);
                Runnable r2 = new Runnable(){

                    @Override
                    public void run() {
                        CooldownsQuery.deleteGlobalCooldowns(Database.getInstance().connect());
                    }
                };
                SCore.schedulerHook.runAsyncTask(r2, 0L);
            }
        };
        SCore.schedulerHook.runAsyncTask(r, 0L);
        Runnable r2 = new Runnable(){

            @Override
            public void run() {
                List<Cooldown> cooldowns = CooldownsManager.getInstance().getAllCooldowns();
                for (Cooldown cd : cooldowns) {
                    if (cd == null) continue;
                    cd.updatePausePlaceholdersConditions();
                }
            }
        };
        SCore.schedulerHook.runAsyncRepeatingTask(r2, 0L, 20L);
    }

    public static void closeServerSaveAll() {
        List<Cooldown> cooldowns = CooldownsManager.getInstance().getAllCooldowns();
        for (Cooldown cd : cooldowns) {
            if (cd == null) continue;
            cd.updatePlayerDisconnect();
        }
        Utils.sendConsoleMsg("&eSCore &7" + cooldowns.size() + " cooldowns saved");
        CooldownsQuery.insertCooldowns(Database.getInstance().connect(), cooldowns);
        CooldownsManager.getInstance().clearCooldowns();
    }

    public static void connectAllOnlinePlayers() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            CooldownsHandler.connect(p);
        }
    }

    public static void connect(final Player p) {
        if (!SCore.pluginHolder.isEnabled()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (!SCore.pluginHolder.isEnabled()) {
                    return;
                }
                List<Cooldown> cooldowns = CooldownsQuery.getCooldownsOf(Database.getInstance().connect(), p.getUniqueId());
                for (Cooldown cd : cooldowns) {
                    cd.updatePlayerReconnect();
                }
                SsomarDev.testMsg("COOLDOWNS SIZE: " + cooldowns.size(), true);
                CooldownsManager.getInstance().addCooldowns(cooldowns);
                Runnable r2 = new Runnable(){

                    @Override
                    public void run() {
                        CooldownsQuery.deleteCooldownsOf(Database.getInstance().connect(), p.getUniqueId());
                    }
                };
                SCore.schedulerHook.runAsyncTask(r2, 0L);
            }
        };
        SCore.schedulerHook.runAsyncTask(r, 0L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void PlayerJoinEvent(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        CooldownsHandler.connect(p);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void PlayerQuitEvent(PlayerQuitEvent e) {
        final Player p = e.getPlayer();
        final ArrayList<Cooldown> cooldowns = new ArrayList<Cooldown>(CooldownsManager.getInstance().getCooldownsOf(p.getUniqueId()));
        if (cooldowns.isEmpty()) {
            return;
        }
        for (Cooldown cd : cooldowns) {
            cd.updatePlayerDisconnect();
        }
        if (!SCore.pluginHolder.isEnabled()) {
            return;
        }
        Runnable r = new Runnable(){
            final /* synthetic */ CooldownsHandler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                CooldownsQuery.insertCooldowns(Database.getInstance().connect(), cooldowns);
                if (!SCore.pluginHolder.isEnabled()) {
                    return;
                }
                Runnable r2 = new Runnable(){

                    @Override
                    public void run() {
                        CooldownsManager.getInstance().removeCooldownsOf(p.getUniqueId());
                    }
                };
                SCore.schedulerHook.runAsyncTask(r2, 0L);
            }
        };
        SCore.schedulerHook.runAsyncTask(r, 0L);
    }
}

