/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.materialwithgroupsandtags.group;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.materialwithgroupsandtags.group.MaterialAndTagsGroupFeatureEditor;
import com.ssomar.score.features.custom.materialwithgroupsandtags.group.MaterialAndTagsGroupFeatureEditorManager;
import com.ssomar.score.features.custom.materialwithgroupsandtags.materialandtags.MaterialAndTagsFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.MaterialWithGroups;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MaterialAndTagsGroupFeature
extends FeatureWithHisOwnEditor<MaterialAndTagsGroupFeature, MaterialAndTagsGroupFeature, MaterialAndTagsGroupFeatureEditor, MaterialAndTagsGroupFeatureEditorManager>
implements FeaturesGroup<MaterialAndTagsFeature> {
    private static final String symbolStart = "{";
    private static final String symbolEnd = "}";
    private static final String symbolEquals = ":";
    private static final String symbolSeparator = "\\+";
    private static final boolean DEBUG = false;
    private Map<String, MaterialAndTagsFeature> materialAndTags;
    private boolean acceptAir;
    private boolean acceptItems;
    private boolean acceptBlocks;
    private boolean notSaveIfEmpty;

    public MaterialAndTagsGroupFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings, boolean acceptAir, boolean acceptItems, boolean acceptBlocks, boolean notSaveIfEmpty) {
        super(parent, featureSettings);
        this.acceptAir = acceptAir;
        this.acceptItems = acceptItems;
        this.acceptBlocks = acceptBlocks;
        this.notSaveIfEmpty = notSaveIfEmpty;
        this.reset();
    }

    @Override
    public void reset() {
        this.materialAndTags = new HashMap<String, MaterialAndTagsFeature>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String attributeID : enchantmentsSection.getKeys(false)) {
                MaterialAndTagsFeature attribute = new MaterialAndTagsFeature(this, attributeID, this.acceptAir, this.acceptItems, this.acceptBlocks);
                List<String> subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.materialAndTags.put(attributeID, attribute);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfEmpty && this.materialAndTags.size() == 0) {
            return;
        }
        ConfigurationSection attributesSection = config.createSection(this.getName());
        for (String enchantmentID : this.materialAndTags.keySet()) {
            this.materialAndTags.get(enchantmentID).save(attributesSection);
        }
    }

    @Override
    public MaterialAndTagsGroupFeature getValue() {
        return this;
    }

    @Override
    public MaterialAndTagsGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oMaterial(s) added: &e" + this.materialAndTags.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public MaterialAndTagsFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (MaterialAndTagsFeature x : this.materialAndTags.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public MaterialAndTagsGroupFeature clone(FeatureParentInterface newParent) {
        MaterialAndTagsGroupFeature eF = new MaterialAndTagsGroupFeature(newParent, this.getFeatureSettings(), this.acceptAir, this.acceptItems, this.acceptBlocks, this.notSaveIfEmpty);
        HashMap<String, MaterialAndTagsFeature> newMaterialAndTags = new HashMap<String, MaterialAndTagsFeature>();
        for (String key : this.materialAndTags.keySet()) {
            newMaterialAndTags.put(key, this.materialAndTags.get(key).clone(eF));
        }
        eF.setMaterialAndTags(newMaterialAndTags);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.materialAndTags.values());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof MaterialAndTagsGroupFeature) || !feature.getName().equals(this.getName())) continue;
            MaterialAndTagsGroupFeature eF = (MaterialAndTagsGroupFeature)feature;
            eF.setMaterialAndTags(this.getMaterialAndTags());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        MaterialAndTagsGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "material";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.materialAndTags.containsKey(id)) continue;
            MaterialAndTagsFeature eF = new MaterialAndTagsFeature(this, id, this.acceptAir, this.acceptItems, this.acceptBlocks);
            this.materialAndTags.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, MaterialAndTagsFeature feature) {
        this.materialAndTags.remove(feature.getId());
    }

    public boolean isValid(Block block) {
        Optional<String> statesStr = Optional.empty();
        if (!SCore.is1v12Less()) {
            statesStr = Optional.ofNullable(block.getBlockData().getAsString(true));
        }
        return this.isValidMaterial(block.getType(), statesStr);
    }

    public Map<String, List<Map<String, String>>> extractCondition() {
        HashMap<String, List<Map<String, String>>> conditions = new HashMap<String, List<Map<String, String>>>();
        for (MaterialAndTagsFeature feature : this.materialAndTags.values()) {
            String s;
            String materialStr = (String)((Optional)feature.getMaterial().getValue()).get();
            HashMap<String, String> tags = new HashMap<String, String>();
            if (((Optional)feature.getTags().getValue()).isPresent() && (s = (String)((Optional)feature.getTags().getValue()).get()).contains(symbolStart)) {
                String datas = s.split("\\{")[1].replace(symbolEnd, "");
                for (String data : datas.split(symbolSeparator)) {
                    String[] dataSplit = data.split(symbolEquals);
                    SsomarDev.testMsg("INSERT CDT STATE: " + dataSplit[0] + "=" + dataSplit[1], false);
                    tags.put(dataSplit[0], dataSplit[1]);
                }
            }
            if (conditions.containsKey(materialStr.toUpperCase())) {
                ((List)conditions.get(materialStr.toUpperCase())).add(tags);
                continue;
            }
            conditions.put(materialStr.toUpperCase(), new ArrayList(Collections.singletonList(tags)));
        }
        return conditions;
    }

    public boolean isValidMaterial(@NotNull Material material, Optional<String> statesStrOpt) {
        Map<String, List<Map<String, String>>> conditions = this.extractCondition();
        HashMap<String, String> states = new HashMap<String, String>();
        try {
            SsomarDev.testMsg(">> verif statesStrOpt: " + statesStrOpt.isPresent(), false);
            if (statesStrOpt.isPresent()) {
                SsomarDev.testMsg(">> verif statesStr: " + statesStrOpt.get(), false);
                String statesStr = statesStrOpt.get().toUpperCase();
                if (statesStr.contains("[")) {
                    String[] spliterStates;
                    String[] spliter1 = statesStr.split("]");
                    String[] spliter2 = spliter1[0].split("\\[");
                    for (String state : spliterStates = spliter2[1].split(",")) {
                        String[] spliterState = state.split("=");
                        SsomarDev.testMsg(">> spliterState: " + spliterState[0] + "=" + spliterState[1], false);
                        states.put(spliterState[0].toUpperCase(), spliterState[1].toUpperCase());
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String mat : conditions.keySet()) {
            SsomarDev.testMsg("before verif: " + mat, false);
            if (!MaterialWithGroups.verif(material, mat)) continue;
            SsomarDev.testMsg(">> verif mat: " + mat, false);
            List<Map<String, String>> tagsList = conditions.get(mat);
            SsomarDev.testMsg(">> verif tagsList empty ?: " + tagsList.isEmpty(), false);
            if (tagsList.isEmpty()) {
                return true;
            }
            for (Map<String, String> tags : tagsList) {
                boolean invalid = false;
                if (tags.isEmpty()) {
                    return true;
                }
                for (String key : tags.keySet()) {
                    String keyUpper = key.toUpperCase();
                    SsomarDev.testMsg(">> verif key: " + key + " contains ? " + states.containsKey(keyUpper), false);
                    if (states.containsKey(keyUpper)) {
                        SsomarDev.testMsg("key value: " + tags.get(key).toUpperCase() + "and real >" + (String)states.get(keyUpper), false);
                        if (!((String)states.get(keyUpper)).equals(tags.get(key).toUpperCase())) {
                            invalid = true;
                            break;
                        }
                    } else {
                        invalid = true;
                    }
                    if (!invalid) continue;
                    break;
                }
                if (invalid) continue;
                return true;
            }
        }
        return false;
    }

    @Generated
    public Map<String, MaterialAndTagsFeature> getMaterialAndTags() {
        return this.materialAndTags;
    }

    @Generated
    public boolean isAcceptAir() {
        return this.acceptAir;
    }

    @Generated
    public boolean isAcceptItems() {
        return this.acceptItems;
    }

    @Generated
    public boolean isAcceptBlocks() {
        return this.acceptBlocks;
    }

    @Generated
    public boolean isNotSaveIfEmpty() {
        return this.notSaveIfEmpty;
    }

    @Generated
    public void setMaterialAndTags(Map<String, MaterialAndTagsFeature> materialAndTags) {
        this.materialAndTags = materialAndTags;
    }

    @Generated
    public void setAcceptAir(boolean acceptAir) {
        this.acceptAir = acceptAir;
    }

    @Generated
    public void setAcceptItems(boolean acceptItems) {
        this.acceptItems = acceptItems;
    }

    @Generated
    public void setAcceptBlocks(boolean acceptBlocks) {
        this.acceptBlocks = acceptBlocks;
    }

    @Generated
    public void setNotSaveIfEmpty(boolean notSaveIfEmpty) {
        this.notSaveIfEmpty = notSaveIfEmpty;
    }
}

